/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class PutAllBackupOperation
extends AbstractMapOperation
implements PartitionAwareOperation,
BackupOperation {
    private MapEntrySet entrySet;

    public PutAllBackupOperation(String name, MapEntrySet entrySet) {
        super(name);
        this.entrySet = entrySet;
    }

    public PutAllBackupOperation() {
    }

    @Override
    public void run() {
        int partitionId = this.getPartitionId();
        RecordStore recordStore = this.mapService.getRecordStore(partitionId, this.name);
        Set<Map.Entry<Data, Data>> entries = this.entrySet.getEntrySet();
        for (Map.Entry<Data, Data> entry : entries) {
            recordStore.set(entry.getKey(), entry.getValue(), -1L);
        }
    }

    @Override
    public Object getResponse() {
        return this.entrySet;
    }

    public String toString() {
        return "PutAllBackupOperation{}";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entrySet);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entrySet = (MapEntrySet)in.readObject();
    }
}

