/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.multimap.tx.MultiMapTransactionLog;
import com.hazelcast.collection.multimap.tx.TransactionLogKey;
import com.hazelcast.collection.multimap.tx.TxnGenerateRecordIdOperation;
import com.hazelcast.collection.multimap.tx.TxnLockAndGetOperation;
import com.hazelcast.collection.multimap.tx.TxnPutOperation;
import com.hazelcast.collection.multimap.tx.TxnRemoveAllOperation;
import com.hazelcast.collection.multimap.tx.TxnRemoveOperation;
import com.hazelcast.collection.operations.CollectionResponse;
import com.hazelcast.collection.operations.CountOperation;
import com.hazelcast.collection.operations.GetAllOperation;
import com.hazelcast.collection.operations.MultiMapOperationFactory;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;

public abstract class TransactionalMultiMapProxySupport
extends AbstractDistributedObject<CollectionService>
implements TransactionalObject {
    protected final CollectionProxyId proxyId;
    protected final TransactionSupport tx;
    protected final MultiMapConfig config;
    private long version = -1L;
    private final Map<Data, Collection<CollectionRecord>> txMap = new HashMap<Data, Collection<CollectionRecord>>();

    protected TransactionalMultiMapProxySupport(NodeEngine nodeEngine, CollectionService service, CollectionProxyId proxyId, TransactionSupport tx, MultiMapConfig config) {
        super(nodeEngine, service);
        this.proxyId = proxyId;
        this.tx = tx;
        this.config = config;
    }

    protected void checkTransactionState() {
        if (!this.tx.getState().equals((Object)Transaction.State.ACTIVE)) {
            throw new TransactionNotActiveException("Transaction is not active!");
        }
    }

    protected boolean putInternal(Data key, Data value) {
        MultiMapTransactionLog log;
        this.throwExceptionIfNull(key);
        this.throwExceptionIfNull(value);
        Collection<CollectionRecord> coll = this.txMap.get(key);
        long recordId = -1L;
        long timeout = this.tx.getTimeoutMillis();
        long ttl = timeout * 3L / 2L;
        if (coll == null) {
            CollectionResponse response = this.lockAndGet(key, timeout, ttl);
            if (response == null) {
                throw new ConcurrentModificationException("Transaction couldn't obtain lock " + this.getThreadId());
            }
            recordId = response.getNextRecordId();
            this.version = response.getTxVersion();
            coll = this.createCollection(response.getRecordCollection(this.getNodeEngine()));
            this.txMap.put(key, coll);
            log = new MultiMapTransactionLog(key, this.proxyId, ttl, this.getThreadId(), this.version);
            this.tx.addTransactionLog(log);
        } else {
            log = (MultiMapTransactionLog)this.tx.getTransactionLog(this.getTxLogKey(key));
        }
        CollectionRecord record = new CollectionRecord(this.config.isBinary() ? value : this.getNodeEngine().toObject(value));
        if (coll.add(record)) {
            if (recordId == -1L) {
                recordId = this.nextId(key);
            }
            record.setRecordId(recordId);
            TxnPutOperation operation = new TxnPutOperation(this.proxyId, key, value, recordId);
            log.addOperation(operation);
            return true;
        }
        return false;
    }

    protected boolean removeInternal(Data key, Data value) {
        MultiMapTransactionLog log;
        this.throwExceptionIfNull(key);
        this.throwExceptionIfNull(value);
        Collection<CollectionRecord> coll = this.txMap.get(key);
        long timeout = this.tx.getTimeoutMillis();
        long ttl = timeout * 3L / 2L;
        if (coll == null) {
            CollectionResponse response = this.lockAndGet(key, timeout, ttl);
            if (response == null) {
                throw new ConcurrentModificationException("Transaction couldn't obtain lock " + this.getThreadId());
            }
            this.version = response.getTxVersion();
            coll = this.createCollection(response.getRecordCollection(this.getNodeEngine()));
            this.txMap.put(key, coll);
            log = new MultiMapTransactionLog(key, this.proxyId, ttl, this.getThreadId(), this.version);
            this.tx.addTransactionLog(log);
        } else {
            log = (MultiMapTransactionLog)this.tx.getTransactionLog(this.getTxLogKey(key));
        }
        CollectionRecord record = new CollectionRecord(this.config.isBinary() ? value : this.getNodeEngine().toObject(value));
        Iterator<CollectionRecord> iterator = coll.iterator();
        long recordId = -1L;
        while (iterator.hasNext()) {
            CollectionRecord r = iterator.next();
            if (!r.equals(record)) continue;
            iterator.remove();
            recordId = r.getRecordId();
            break;
        }
        if (this.version != -1L || recordId != -1L) {
            TxnRemoveOperation operation = new TxnRemoveOperation(this.proxyId, key, recordId, value);
            log.addOperation(operation);
            return recordId != -1L;
        }
        return false;
    }

    protected Collection<CollectionRecord> removeAllInternal(Data key) {
        MultiMapTransactionLog log;
        this.throwExceptionIfNull(key);
        long timeout = this.tx.getTimeoutMillis();
        long ttl = timeout * 3L / 2L;
        Collection<CollectionRecord> coll = this.txMap.get(key);
        if (coll == null) {
            CollectionResponse response = this.lockAndGet(key, timeout, ttl);
            if (response == null) {
                throw new ConcurrentModificationException("Transaction couldn't obtain lock " + this.getThreadId());
            }
            this.version = response.getTxVersion();
            coll = this.createCollection(response.getRecordCollection(this.getNodeEngine()));
            log = new MultiMapTransactionLog(key, this.proxyId, ttl, this.getThreadId(), this.version);
            this.tx.addTransactionLog(log);
        } else {
            log = (MultiMapTransactionLog)this.tx.getTransactionLog(this.getTxLogKey(key));
        }
        this.txMap.put(key, this.createCollection());
        TxnRemoveAllOperation operation = new TxnRemoveAllOperation(this.proxyId, key, coll);
        log.addOperation(operation);
        return coll;
    }

    protected Collection<CollectionRecord> getInternal(Data key) {
        this.throwExceptionIfNull(key);
        Collection<CollectionRecord> coll = this.txMap.get(key);
        if (coll == null) {
            GetAllOperation operation = new GetAllOperation(this.proxyId, key);
            try {
                int partitionId = this.getNodeEngine().getPartitionService().getPartitionId(key);
                Invocation invocation = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:collectionService", (Operation)operation, partitionId).build();
                Future f = invocation.invoke();
                CollectionResponse response = (CollectionResponse)f.get();
                coll = response.getRecordCollection(this.getNodeEngine());
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return coll;
    }

    protected int valueCountInternal(Data key) {
        this.throwExceptionIfNull(key);
        Collection<CollectionRecord> coll = this.txMap.get(key);
        if (coll == null) {
            CountOperation operation = new CountOperation(this.proxyId, key);
            try {
                int partitionId = this.getNodeEngine().getPartitionService().getPartitionId(key);
                Invocation invocation = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:collectionService", (Operation)operation, partitionId).build();
                Future f = invocation.invoke();
                return (Integer)f.get();
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return coll.size();
    }

    public int size() {
        this.checkTransactionState();
        try {
            Map<Integer, Object> results = this.getNodeEngine().getOperationService().invokeOnAllPartitions("hz:impl:collectionService", new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.SIZE));
            int size = 0;
            for (Object obj : results.values()) {
                if (obj == null) continue;
                Integer result = (Integer)this.getNodeEngine().toObject(obj);
                size += result.intValue();
            }
            for (Data key : this.txMap.keySet()) {
                MultiMapTransactionLog log = (MultiMapTransactionLog)this.tx.getTransactionLog(this.getTxLogKey(key));
                if (log == null) continue;
                size += log.size();
            }
            return size;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private TransactionLogKey getTxLogKey(Data key) {
        return new TransactionLogKey(this.proxyId, key);
    }

    @Override
    public Object getId() {
        return this.proxyId;
    }

    @Override
    public String getName() {
        return this.proxyId.getName();
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:collectionService";
    }

    private void throwExceptionIfNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    private int getThreadId() {
        return ThreadUtil.getThreadId();
    }

    private CollectionResponse lockAndGet(Data key, long timeout, long ttl) {
        NodeEngine nodeEngine = this.getNodeEngine();
        TxnLockAndGetOperation operation = new TxnLockAndGetOperation(this.proxyId, key, timeout, ttl, this.getThreadId());
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:collectionService", (Operation)operation, partitionId).build();
            Future f = invocation.invoke();
            return (CollectionResponse)f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private long nextId(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        TxnGenerateRecordIdOperation operation = new TxnGenerateRecordIdOperation(this.proxyId, key);
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:collectionService", (Operation)operation, partitionId).build();
            Future f = invocation.invoke();
            return (Long)f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private Collection<CollectionRecord> createCollection() {
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.SET)) {
            return new HashSet<CollectionRecord>();
        }
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.LIST)) {
            return new ArrayList<CollectionRecord>();
        }
        return null;
    }

    private Collection<CollectionRecord> createCollection(Collection<CollectionRecord> coll) {
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.SET)) {
            return new HashSet<CollectionRecord>(coll);
        }
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.LIST)) {
            return new ArrayList<CollectionRecord>(coll);
        }
        return null;
    }
}

