/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class CollectionContainer {
    final CollectionProxyId proxyId;
    final CollectionService service;
    final NodeEngine nodeEngine;
    final MultiMapConfig config;
    final ConcurrentMap<Data, CollectionWrapper> collections = new ConcurrentHashMap<Data, CollectionWrapper>(1000);
    final DefaultObjectNamespace lockNamespace;
    final LockStore lockStore;
    final int partitionId;
    final AtomicLong idGen = new AtomicLong();
    final AtomicLong lastAccessTime = new AtomicLong();
    final AtomicLong lastUpdateTime = new AtomicLong();
    final long creationTime;

    public CollectionContainer(CollectionProxyId proxyId, CollectionService service, int partitionId) {
        this.proxyId = proxyId;
        this.service = service;
        this.nodeEngine = service.getNodeEngine();
        this.partitionId = partitionId;
        this.config = this.nodeEngine.getConfig().getMultiMapConfig(proxyId.name);
        this.lockNamespace = new DefaultObjectNamespace("hz:impl:collectionService", proxyId);
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        this.lockStore = lockService == null ? null : lockService.createLockStore(partitionId, this.lockNamespace);
        this.creationTime = Clock.currentTimeMillis();
    }

    public boolean canAcquireLock(Data dataKey, String caller, int threadId) {
        return this.lockStore != null && this.lockStore.canAcquireLock(dataKey, caller, threadId);
    }

    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    public boolean txnLock(Data key, String caller, int threadId, long ttl) {
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, ttl);
    }

    public boolean unlock(Data key, String caller, int threadId) {
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId);
    }

    public boolean forceUnlock(Data key) {
        return this.lockStore != null && this.lockStore.forceUnlock(key);
    }

    public boolean extendLock(Data key, String caller, int threadId, long ttl) {
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    public String getLockOwnerInfo(Data dataKey) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(dataKey) : null;
    }

    public long nextId() {
        return this.idGen.getAndIncrement();
    }

    public CollectionWrapper getOrCreateCollectionWrapper(Data dataKey) {
        CollectionWrapper wrapper = (CollectionWrapper)this.collections.get(dataKey);
        if (wrapper == null) {
            Collection<CollectionRecord> coll = this.service.createNew(this.proxyId);
            wrapper = new CollectionWrapper(coll);
            this.collections.put(dataKey, wrapper);
        }
        return wrapper;
    }

    public CollectionWrapper getCollectionWrapper(Data dataKey) {
        return (CollectionWrapper)this.collections.get(dataKey);
    }

    public Collection<CollectionRecord> removeCollection(Data dataKey) {
        CollectionWrapper wrapper = (CollectionWrapper)this.collections.remove(dataKey);
        return wrapper != null ? wrapper.getCollection() : null;
    }

    public Set<Data> keySet() {
        Set keySet = this.collections.keySet();
        HashSet<Data> keys = new HashSet<Data>(keySet.size());
        keys.addAll(keySet);
        return keys;
    }

    public Collection<CollectionRecord> values() {
        LinkedList<CollectionRecord> valueCollection = new LinkedList<CollectionRecord>();
        for (CollectionWrapper wrapper : this.collections.values()) {
            valueCollection.addAll(wrapper.getCollection());
        }
        return valueCollection;
    }

    public boolean containsKey(Data key) {
        return this.collections.containsKey(key);
    }

    public boolean containsEntry(boolean binary, Data key, Data value) {
        CollectionWrapper wrapper = (CollectionWrapper)this.collections.get(key);
        if (wrapper == null) {
            return false;
        }
        CollectionRecord record = new CollectionRecord(binary ? value : this.nodeEngine.toObject(value));
        return wrapper.getCollection().contains(record);
    }

    public boolean containsValue(boolean binary, Data value) {
        for (Data key : this.collections.keySet()) {
            if (!this.containsEntry(binary, key, value)) continue;
            return true;
        }
        return false;
    }

    public Map<Data, Collection<CollectionRecord>> copyCollections() {
        HashMap<Data, Collection<CollectionRecord>> map = new HashMap<Data, Collection<CollectionRecord>>(this.collections.size());
        for (Map.Entry entry : this.collections.entrySet()) {
            Data key = (Data)entry.getKey();
            Collection<CollectionRecord> col = this.copyCollection(((CollectionWrapper)entry.getValue()).getCollection());
            map.put(key, col);
        }
        return map;
    }

    private Collection<CollectionRecord> copyCollection(Collection<CollectionRecord> coll) {
        ArrayList<CollectionRecord> copy = new ArrayList<CollectionRecord>(coll.size());
        copy.addAll(coll);
        return copy;
    }

    public int size() {
        int size = 0;
        for (CollectionWrapper wrapper : this.collections.values()) {
            size += wrapper.getCollection().size();
        }
        return size;
    }

    public void clearCollections() {
        Set<Data> locks = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, CollectionWrapper> temp = new HashMap<Data, CollectionWrapper>(locks.size());
        for (Data key : locks) {
            CollectionWrapper wrapper = (CollectionWrapper)this.collections.get(key);
            if (wrapper == null) continue;
            temp.put(key, wrapper);
        }
        this.collections.clear();
        this.collections.putAll(temp);
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public MultiMapConfig getConfig() {
        return this.config;
    }

    public void destroy() {
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.clearLockStore(this.partitionId, this.lockNamespace);
        }
        this.collections.clear();
    }

    public void access() {
        this.lastAccessTime.set(Clock.currentTimeMillis());
    }

    public void update() {
        this.lastUpdateTime.set(Clock.currentTimeMillis());
    }

    public long getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime.get();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLockedCount() {
        return this.lockStore.getLockedKeys().size();
    }
}

