/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.bind.JAXBContext;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Holder;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.BindingProvider;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.binding.SOAPBinding;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.client.proxy.ProxyAsyncListener;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.controller.InvocationController;
import org.apache.axis2.jaxws.core.controller.InvocationControllerFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.validator.EndpointDescriptionValidator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.factory.MethodMarshallerFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescriptionFactory;
import org.apache.axis2.jaxws.server.config.AddressingConfigurator;
import org.apache.axis2.jaxws.spi.Binding;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.axis2.jaxws.util.WSDLExtensionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSProxyHandler
extends BindingProvider
implements InvocationHandler {
    private static Log log = LogFactory.getLog(JAXWSProxyHandler.class);
    private Class seiClazz = null;
    private Method method = null;
    protected ServiceDescription serviceDesc = null;
    protected InvocationController controller;

    public JAXWSProxyHandler(ServiceDelegate delegate, Class seiClazz, EndpointDescription epDesc, WebServiceFeature ... features) {
        this(delegate, seiClazz, epDesc, (EndpointReference)null, (String)null, features);
    }

    public JAXWSProxyHandler(ServiceDelegate delegate, Class seiClazz, EndpointDescription epDesc, EndpointReference epr, String addressingNamespace, WebServiceFeature ... features) {
        super(delegate, epDesc, epr, addressingNamespace, features);
        this.seiClazz = seiClazz;
        this.serviceDesc = delegate.getServiceDescription();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Attemping to invoke Method: " + method.getName()));
        }
        this.method = method;
        if (!this.isValidMethodCall(method)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("proxyErr1", method.getName(), this.seiClazz.getName()));
        }
        if (!this.isPublic(method)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("proxyPrivateMethod", method.getName()));
        }
        if (this.isBindingProviderInvoked(method)) {
            if (debug) {
                log.debug((Object)"Invoking a public method on the javax.xml.ws.BindingProvider interface.");
            }
            try {
                return method.invoke((Object)this, args);
            }
            catch (Throwable e) {
                if (debug) {
                    log.debug((Object)("An error occured while invoking the method: " + e.getMessage()));
                }
                throw ExceptionFactory.makeWebServiceException(e);
            }
        }
        OperationDescription operationDesc = this.endpointDesc.getEndpointInterfaceDescription().getOperation(method);
        if (this.isMethodExcluded(operationDesc)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("proxyExcludedMethod", method.getName()));
        }
        return this.invokeSEIMethod(method, args);
    }

    private Object invokeSEIMethod(Method method, Object[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to invoke SEI Method " + method.getName()));
        }
        OperationDescription operationDesc = this.endpointDesc.getEndpointInterfaceDescription().getOperation(method);
        InvocationContext requestIC = InvocationContextFactory.createInvocationContext(null);
        MessageContext request = this.createRequest(method, args);
        request.getAxisMessageContext().setProperty("org.apache.axis2.jaxws.BindingProvider", this);
        request.setEndpointDescription(this.getEndpointDescription());
        request.setOperationDescription(operationDesc);
        Binding bnd = (Binding)this.getBinding();
        if (bnd != null && bnd instanceof javax.xml.ws.soap.SOAPBinding) {
            if (((javax.xml.ws.soap.SOAPBinding)bnd).isMTOMEnabled()) {
                Message requestMsg = request.getMessage();
                requestMsg.setMTOMEnabled(true);
                int threshold = ((SOAPBinding)bnd).getMTOMThreshold();
                request.setProperty("mtomThreshold", new Integer(threshold));
            }
            if (((SOAPBinding)bnd).isRespectBindingEnabled()) {
                EndpointDescription endpointDescription = this.getEndpointDescription();
                endpointDescription.setRespectBinding(true);
                WSDLExtensionUtils.processExtensions(endpointDescription);
                EndpointDescriptionValidator endpointValidator = new EndpointDescriptionValidator(endpointDescription);
                boolean isEndpointValid = endpointValidator.validate(true);
                if (!isEndpointValid) {
                    String msg = Messages.getMessage("endpointDescriptionValidationErrors", endpointValidator.toString());
                    throw ExceptionFactory.makeWebServiceException(msg);
                }
            }
        }
        requestIC.setHandlers(bnd.getHandlerChain());
        requestIC.setRequestMessageContext(request);
        requestIC.setServiceClient(this.serviceDelegate.getServiceClient(this.endpointDesc.getPortQName()));
        if (this.requestContext.containsKey("javax.xml.ws.session.maintain") && ((Boolean)this.requestContext.get("javax.xml.ws.session.maintain")).booleanValue() && this.requestContext.containsKey("Cookie") && this.requestContext.get("Cookie") != null && requestIC.getServiceClient().getServiceContext().getProperty("Cookie") == null) {
            requestIC.getServiceClient().getServiceContext().setProperty("Cookie", this.requestContext.get("Cookie"));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Client-app defined Cookie property (assume to be session cookie) on request context copied to service context.  Caution:  server may or may not support sessions, but client app will not be informed when not supported.");
            }
        }
        ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), request);
        this.configureAddressing(request, this);
        bnd.configure(request, this);
        InvocationControllerFactory icf = (InvocationControllerFactory)FactoryRegistry.getFactory(InvocationControllerFactory.class);
        this.controller = icf.getInvocationController();
        if (this.controller == null) {
            throw new WebServiceException(Messages.getMessage("missingInvocationController"));
        }
        if (operationDesc.isOneWay()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"OneWay Call");
            }
            this.controller.invokeOneWay(requestIC);
            this.checkMaintainSessionState(request, requestIC);
        }
        if (method.getReturnType() == Future.class) {
            ExecutorService es;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Async Callback");
            }
            AsyncHandler asyncHandler = null;
            for (Object obj : args) {
                if (obj == null || !AsyncHandler.class.isAssignableFrom(obj.getClass())) continue;
                asyncHandler = (AsyncHandler)obj;
                break;
            }
            if (asyncHandler == null) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("proxyNullCallback"));
            }
            AsyncResponse listener = this.createProxyListener(args, operationDesc);
            requestIC.setAsyncResponseListener(listener);
            if (this.serviceDelegate.getExecutor() != null && this.serviceDelegate.getExecutor() instanceof ExecutorService && (es = (ExecutorService)this.serviceDelegate.getExecutor()).isShutdown()) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ExecutorShutdown"));
            }
            requestIC.setExecutor(this.serviceDelegate.getExecutor());
            Future<?> future = this.controller.invokeAsync(requestIC, asyncHandler);
            this.checkMaintainSessionState(request, requestIC);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exiting the method invokeSEIMethod() - Async Callback ");
            }
            return future;
        }
        if (method.getReturnType() == Response.class) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Async Polling");
            }
            AsyncResponse listener = this.createProxyListener(args, operationDesc);
            requestIC.setAsyncResponseListener(listener);
            requestIC.setExecutor(this.serviceDelegate.getExecutor());
            Response response = this.controller.invokeAsync(requestIC);
            this.checkMaintainSessionState(request, requestIC);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exiting the method invokeSEIMethod() - Async Polling ");
            }
            return response;
        }
        if (!operationDesc.isOneWay()) {
            InvocationContext responseIC = this.controller.invoke(requestIC);
            this.checkMaintainSessionState(request, requestIC);
            MessageContext responseContext = responseIC.getResponseMessageContext();
            ApplicationContextMigratorUtil.performMigrationFromMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getResponseContext(), responseContext);
            Object responseObj = this.createResponse(method, args, responseContext, operationDesc);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exiting the method invokeSEIMethod() - Sync");
            }
            return responseObj;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exiting the method invokeSEIMethod() - One Way ");
        }
        return null;
    }

    private void configureAddressing(MessageContext messageContext, BindingProvider bindingProvider) {
        javax.xml.ws.soap.SOAPBinding soapBinding;
        SOAPBinding implBinding;
        Binding binding = (Binding)bindingProvider.getBinding();
        if (binding != null && binding instanceof javax.xml.ws.soap.SOAPBinding && (implBinding = (SOAPBinding)(soapBinding = (javax.xml.ws.soap.SOAPBinding)binding)).isAddressingConfigured()) {
            String addressingNamespace = implBinding.getAddressingNamespace();
            Boolean disableAddressing = new Boolean(true);
            String addressingRequired = "unspecified";
            if (implBinding.isAddressingEnabled()) {
                addressingNamespace = "http://www.w3.org/2005/08/addressing";
                disableAddressing = new Boolean(false);
                if (implBinding.isAddressingRequired()) {
                    addressingRequired = "required";
                }
            }
            messageContext.setProperty("WSAddressingVersion", addressingNamespace);
            messageContext.setProperty("disableAddressingForOutMessages", disableAddressing);
            messageContext.setProperty("addressingRequirementParameter", addressingRequired);
            messageContext.setProperty("wsamInvocationPattern", AddressingConfigurator.mapResponseAttributeToAddressing(implBinding.getAddressingResponses()));
        }
    }

    private AsyncResponse createProxyListener(Object[] args, OperationDescription operationDesc) {
        ProxyAsyncListener listener = new ProxyAsyncListener(operationDesc);
        listener.setHandler(this);
        listener.setInputArgs(args);
        return listener;
    }

    protected boolean isAsync() {
        String methodName = this.method.getName();
        Class<Object> returnType = this.method.getReturnType();
        return methodName.endsWith("Async") && (returnType.isAssignableFrom(Response.class) || returnType.isAssignableFrom(Future.class));
    }

    protected MessageContext createRequest(Method method, Object[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating a new Message using the request parameters.");
        }
        OperationDescription operationDesc = this.endpointDesc.getEndpointInterfaceDescription().getOperation(method);
        MessageContext request = new MessageContext();
        ClassLoader cl = JAXWSProxyHandler.chooseClassLoader(this.seiClazz, this.serviceDesc);
        request.setProperty("CACHE_CLASSLOADER", cl);
        Message message = MethodMarshallerFactory.getMarshaller(operationDesc, true, null).marshalRequest(args, operationDesc, this.getRequestContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request Message created successfully.");
        }
        request.setMessage(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request MessageContext created successfully.");
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createResponse(Method method, Object[] args, MessageContext responseContext, OperationDescription operationDesc) throws Throwable {
        Message responseMsg = responseContext.getMessage();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processing the response Message to create the return value(s).");
            }
            if (JAXWSProxyHandler.hasFaultResponse(responseContext)) {
                Throwable t = JAXWSProxyHandler.getFaultResponse(responseContext, operationDesc);
                throw t;
            }
            ClassLoader cl = (ClassLoader)responseContext.getProperty("CACHE_CLASSLOADER");
            if (cl == null) {
                MessageContext requestMC;
                InvocationContext ic = responseContext.getInvocationContext();
                if (ic != null && (requestMC = ic.getRequestMessageContext()) != null && (cl = (ClassLoader)responseContext.getProperty("CACHE_CLASSLOADER")) != null && log.isDebugEnabled()) {
                    log.debug((Object)("Obtained ClassLoader for the request context: " + cl));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Obtained ClassLoader for the response context: " + cl));
            }
            Object object = MethodMarshallerFactory.getMarshaller(operationDesc, true, cl).demarshalResponse(responseMsg, args, operationDesc);
            if (log.isDebugEnabled()) {
                log.debug((Object)"The response was processed and the return value created successfully.");
            }
            Object object2 = object;
            return object2;
        }
        finally {
            responseMsg.close();
            try {
                responseContext.freeInputStream();
            }
            catch (Throwable t) {
                throw ExceptionFactory.makeWebServiceException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Throwable getFaultResponse(MessageContext msgCtx, OperationDescription opDesc) {
        Message msg = msgCtx.getMessage();
        try {
            if (opDesc.isJAXWSAsyncClientMethod()) {
                opDesc = opDesc.getSyncOperation();
            }
            if (msg != null && msg.isFault()) {
                ClassLoader cl = (ClassLoader)msgCtx.getProperty("CACHE_CLASSLOADER");
                Throwable object = MethodMarshallerFactory.getMarshaller(opDesc, true, cl).demarshalFaultResponse(msg, opDesc);
                if (log.isDebugEnabled() && object != null) {
                    log.debug((Object)"A fault was found and processed.");
                    log.debug((Object)("Throwing a fault of type: " + object.getClass().getName() + " back to the clent."));
                }
                Throwable throwable = object;
                return throwable;
            }
            if (msgCtx.getLocalException() != null) {
                WebServiceException cl = ExceptionFactory.makeWebServiceException(msgCtx.getLocalException());
                return cl;
            }
        }
        finally {
            try {
                msgCtx.freeInputStream();
            }
            catch (Throwable t) {
                throw ExceptionFactory.makeWebServiceException(t);
            }
        }
        return null;
    }

    protected static boolean hasFaultResponse(MessageContext mc) {
        if (mc.getMessage() != null && mc.getMessage().isFault()) {
            return true;
        }
        return mc.getLocalException() != null;
    }

    private boolean isBindingProviderInvoked(Method method) {
        Class<?> methodsClass = method.getDeclaringClass();
        return this.seiClazz != methodsClass;
    }

    private boolean isValidMethodCall(Method method) {
        Class<javax.xml.ws.BindingProvider> clazz = method.getDeclaringClass();
        return clazz.isAssignableFrom(this.seiClazz) || clazz.isAssignableFrom(org.apache.axis2.jaxws.spi.BindingProvider.class) || clazz.isAssignableFrom(javax.xml.ws.BindingProvider.class);
    }

    private boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private boolean isMethodExcluded(OperationDescription operationDesc) {
        return operationDesc.isExcluded();
    }

    public Class getSeiClazz() {
        return this.seiClazz;
    }

    public void setSeiClazz(Class seiClazz) {
        this.seiClazz = seiClazz;
    }

    private static ClassLoader chooseClassLoader(Class cls, ServiceDescription serviceDesc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Choose Classloader for " + cls));
        }
        ClassLoader cl = null;
        ClassLoader contextCL = JAXWSProxyHandler.getContextClassLoader();
        ClassLoader classCL = JAXWSProxyHandler.getClassLoader(cls);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Context ClassLoader is " + contextCL));
            log.debug((Object)("Class ClassLoader is " + classCL));
        }
        if (classCL == null || contextCL == classCL) {
            cl = contextCL;
        } else {
            JAXBContext jbc_classCL;
            Holder holder_classCL;
            JAXBContext jbc_contextCL;
            Holder holder_contextCL;
            block26: {
                MarshalServiceRuntimeDescription marshalDesc;
                block25: {
                    marshalDesc = MarshalServiceRuntimeDescriptionFactory.get(serviceDesc);
                    holder_contextCL = new Holder();
                    jbc_contextCL = null;
                    try {
                        jbc_contextCL = JAXBUtils.getJAXBContext(marshalDesc.getPackages(), (Holder<JAXBUtils.CONSTRUCTION_TYPE>)holder_contextCL, marshalDesc.getPackagesKey(), contextCL, null);
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) break block25;
                        log.debug((Object)("Error occured..Processing continues " + t));
                    }
                }
                holder_classCL = new Holder();
                jbc_classCL = null;
                try {
                    jbc_classCL = JAXBUtils.getJAXBContext(marshalDesc.getPackages(), (Holder<JAXBUtils.CONSTRUCTION_TYPE>)holder_classCL, marshalDesc.getPackagesKey(), contextCL, null);
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block26;
                    log.debug((Object)("Error occured..Processing continues " + t));
                }
            }
            if (jbc_classCL == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not load JAXBContext for Class ClassLoader");
                }
                cl = contextCL;
            } else if (jbc_contextCL == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not load JAXBContext for Context ClassLoader");
                }
                cl = classCL;
            } else if (holder_contextCL.value == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH && holder_classCL.value == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Loaded both JAXBContexts with BY_CONTEXT_PATH.  Choose Class ClassLoader");
                }
                cl = classCL;
            } else if (holder_contextCL.value == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Successfully loaded JAXBContext with Contxst ClassLoader.  Choose Context ClassLoader");
                }
                cl = contextCL;
            } else if (holder_classCL.value == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Successfully loaded JAXBContext with Class ClassLoader.  Choose Class ClassLoader");
                }
                cl = classCL;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Default to Class ClassLoader");
                }
                cl = classCL;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Chosen ClassLoader is " + cls));
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    private static ClassLoader getClassLoader(final Class cls) {
        ClassLoader cl;
        block3: {
            if (cls == null) {
                return null;
            }
            cl = null;
            try {
                cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return cls.getClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
        }
        return cl;
    }
}

