/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionFactory {
    protected static Log log = LogFactory.getLog((String)ExceptionFactory.class.getName());

    private ExceptionFactory() {
    }

    public static WebServiceException makeWebServiceException(String message, Throwable throwable) {
        try {
            WebServiceException e = (WebServiceException)((Object)ExceptionFactory.findException(throwable, WebServiceException.class));
            if (e == null) {
                e = ExceptionFactory.createWebServiceException(message, throwable);
            }
            return e;
        }
        catch (RuntimeException re) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("exceptionDuringExceptionFlow"), (Throwable)re);
            }
            throw re;
        }
    }

    public static ProtocolException makeProtocolException(String message, Throwable throwable) {
        try {
            ProtocolException e = (ProtocolException)ExceptionFactory.findException(throwable, ProtocolException.class);
            if (e == null) {
                e = ExceptionFactory.createProtocolException(message, throwable);
            }
            return e;
        }
        catch (RuntimeException re) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("exceptionDuringExceptionFlow"), (Throwable)re);
            }
            throw re;
        }
    }

    public static WebServiceException makeWebServiceException(String message) {
        return ExceptionFactory.makeWebServiceException(message, null);
    }

    public static WebServiceException makeWebServiceException(Throwable throwable) {
        return ExceptionFactory.makeWebServiceException(null, throwable);
    }

    private static WebServiceException createWebServiceException(String message, Throwable t) {
        String meMessage;
        WebServiceException me = (WebServiceException)((Object)ExceptionFactory.findException(t, WebServiceException.class));
        if (me != null && (meMessage = me.getMessage()) != null) {
            message = message == null ? meMessage : message + ": " + meMessage;
        }
        Throwable rootCause = null;
        if (t != null) {
            rootCause = ExceptionFactory.getRootCause(t);
        }
        rootCause = rootCause == null ? t : rootCause;
        WebServiceException e = null;
        String enhancedMessage = ExceptionFactory.enhanceMessage(rootCause);
        if (enhancedMessage != null) {
            message = message != null ? message + ": " + enhancedMessage : enhancedMessage;
        }
        e = message != null ? new WebServiceException(message, rootCause) : new WebServiceException(rootCause);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Create Exception:", (Throwable)e);
        }
        return e;
    }

    private static ProtocolException createProtocolException(String message, Throwable t) {
        Throwable rootCause = null;
        if (t != null) {
            rootCause = ExceptionFactory.getRootCause(t);
        }
        rootCause = rootCause == null ? t : rootCause;
        ProtocolException e = null;
        e = message != null ? new ProtocolException(message, rootCause) : new ProtocolException(rootCause);
        if (log.isDebugEnabled()) {
            log.debug((Object)"create Exception:", (Throwable)e);
        }
        return e;
    }

    private static Exception findException(Throwable t, Class cls) {
        while (t != null) {
            if (cls.isAssignableFrom(t.getClass())) {
                return (Exception)t;
            }
            t = ExceptionFactory.getCause(t);
        }
        return null;
    }

    private static Throwable getCause(Throwable t) {
        Throwable cause = null;
        if (t instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)t).getTargetException();
        }
        if (cause == null) {
            cause = t.getCause();
        }
        return cause;
    }

    private static Throwable getRootCause(Throwable t) {
        while (t != null) {
            Throwable nextCause = null;
            if (t instanceof InvocationTargetException || t instanceof OMException || t instanceof AxisFault) {
                nextCause = ExceptionFactory.getCause(t);
                if (nextCause == null) {
                    ExceptionFactory.logRootCause(t);
                    return t;
                }
                t = nextCause;
                continue;
            }
            ExceptionFactory.logRootCause(t);
            return t;
        }
        ExceptionFactory.logRootCause(t);
        return t;
    }

    private static String enhanceMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos, true);
        t.printStackTrace(ps);
        String stackTrace = baos.toString();
        if (t instanceof StackOverflowError && stackTrace.contains("JAXB")) {
            return Messages.getMessage("JABGraphProblem");
        }
        return null;
    }

    private static void logRootCause(Throwable t) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Root Cause:" + t.toString()));
            log.debug((Object)("stack:" + ExceptionFactory.stackToString(t)));
        }
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }
}

