/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store.jdbc;

import javax.sql.DataSource;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.lucene.engine.store.jdbc.DataSourceProvider;

public abstract class AbstractDataSourceProvider
implements DataSourceProvider {
    private DataSource dataSource;
    protected String driverClass;
    protected String username;
    protected String password;
    protected boolean autoCommit;
    protected boolean externalAutoCommit;

    public void configure(String url, CompassSettings settings) throws CompassException {
        this.driverClass = settings.getSetting("compass.engine.store.jdbc.connection.driverClass");
        this.username = settings.getSetting("compass.engine.store.jdbc.connection.username");
        this.password = settings.getSetting("compass.engine.store.jdbc.connection.password");
        String autoCommitSetting = settings.getSetting("compass.engine.store.jdbc.connection.autoCommit", "false");
        if ("external".equalsIgnoreCase(autoCommitSetting)) {
            this.externalAutoCommit = true;
        } else {
            this.externalAutoCommit = false;
            this.autoCommit = "true".equalsIgnoreCase(autoCommitSetting);
        }
        this.dataSource = this.doCreateDataSource(url, settings);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void closeDataSource() {
    }

    protected abstract DataSource doCreateDataSource(String var1, CompassSettings var2) throws CompassException;
}

