/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import org.apache.axis2.context.MessageContext;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;

public class ResponseSessionCookie
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String sessionCookie = null;
        MessageContext msgctx = (MessageContext)context.getAttribute("axis.message.context");
        if (msgctx != null) {
            sessionCookie = (String)msgctx.getProperty("Cookie");
        }
        if (sessionCookie == null) {
            sessionCookie = (String)context.getAttribute("Cookie");
        }
        if (sessionCookie != null) {
            CharArrayBuffer buffer1 = new CharArrayBuffer(sessionCookie.length() + 40);
            buffer1.append("Set-Cookie");
            buffer1.append(": ");
            buffer1.append("JSESSIONID");
            buffer1.append("=");
            buffer1.append(sessionCookie);
            response.addHeader(new BufferedHeader(buffer1));
            CharArrayBuffer buffer2 = new CharArrayBuffer(sessionCookie.length() + 50);
            buffer2.append("Set-Cookie2");
            buffer2.append(": ");
            buffer2.append("JSESSIONID");
            buffer2.append("=");
            buffer2.append(sessionCookie);
            buffer2.append("; ");
            int port = response.getParams().getIntParameter("axis.listener.port", 0);
            if (port > 0) {
                buffer2.append("Port=\"");
                buffer2.append(Integer.toString(port));
                buffer2.append("\"; ");
            }
            buffer2.append("Version=1");
            response.addHeader(new BufferedHeader(buffer2));
        }
    }
}

