/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpRequest;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

public class AxisHttpRequestImpl
implements AxisHttpRequest {
    private final HttpRequest request;
    private final AxisHttpConnection conn;
    private final HttpProcessor httpproc;
    private final HttpContext context;

    public AxisHttpRequestImpl(AxisHttpConnection conn, HttpRequest request, HttpProcessor httpproc, HttpContext context) {
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpproc == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        this.request = request;
        this.conn = conn;
        this.httpproc = httpproc;
        this.context = context;
    }

    public void prepare() throws IOException, HttpException {
        this.context.setAttribute("http.connection", this.conn);
        this.context.setAttribute("http.request", this.request);
        this.httpproc.process(this.request, this.context);
    }

    @Override
    public String getMethod() {
        return this.request.getRequestLine().getMethod();
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestLine().getUri();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.request.getRequestLine().getProtocolVersion();
    }

    @Override
    public String getContentType() {
        Header header = this.request.getFirstHeader("Content-Type");
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return this.conn.getInputStream();
    }

    @Override
    public void addHeader(Header header) {
        this.request.addHeader(header);
    }

    @Override
    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.request.containsHeader(name);
    }

    @Override
    public Header[] getAllHeaders() {
        return this.request.getAllHeaders();
    }

    @Override
    public Header getFirstHeader(String name) {
        return this.request.getFirstHeader(name);
    }

    @Override
    public Header[] getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    @Override
    public Header getLastHeader(String name) {
        return this.request.getLastHeader(name);
    }

    @Override
    public HeaderIterator headerIterator() {
        return this.request.headerIterator();
    }

    @Override
    public HeaderIterator headerIterator(String name) {
        return this.request.headerIterator(name);
    }

    @Override
    public void removeHeader(Header header) {
        this.request.removeHeader(header);
    }

    @Override
    public void removeHeaders(String name) {
        this.request.removeHeaders(name);
    }

    @Override
    public void setHeader(Header header) {
        this.request.setHeader(header);
    }

    @Override
    public void setHeader(String name, String value) {
        this.request.setHeader(name, value);
    }

    @Override
    public void setHeaders(Header[] headers) {
        this.request.setHeaders(headers);
    }

    @Override
    public HttpParams getParams() {
        return this.request.getParams();
    }

    @Override
    public void setParams(HttpParams params) {
        this.request.setParams(params);
    }
}

