/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.base.TransportMBeanSupport;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTransportSender
extends AbstractHandler
implements TransportSender {
    protected Log log = null;
    protected ConfigurationContext cfgCtx = null;
    private TransportInDescription transportIn = null;
    private TransportOutDescription transportOut = null;
    private TransportMBeanSupport mbeanSupport;
    protected MetricsCollector metrics = new MetricsCollector();
    private int state = 0;

    protected AbstractTransportSender() {
        this.log = LogFactory.getLog(this.getClass());
    }

    @Override
    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.transportOut = transportOut;
        this.transportIn = cfgCtx.getAxisConfiguration().getTransportIn(this.getTransportName());
        this.state = 1;
        this.mbeanSupport = new TransportMBeanSupport(this, this.getTransportName());
        this.mbeanSupport.register();
        this.log.info(this.getTransportName().toUpperCase() + " Sender started");
    }

    @Override
    public void stop() {
        if (this.state != 1) {
            return;
        }
        this.state = 0;
        this.mbeanSupport.unregister();
        this.log.info(this.getTransportName().toUpperCase() + " Sender Shutdown");
    }

    @Override
    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public abstract void sendMessage(MessageContext var1, String var2, OutTransportInfo var3) throws AxisFault;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        String targetAddress = (String)msgContext.getProperty("TransportURL");
        if (targetAddress != null) {
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            targetAddress = msgContext.getTo().getAddress();
            if (msgContext.getTo().hasNoneAddress()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else {
            if (!msgContext.isServerSide()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, null, (OutTransportInfo)msgContext.getProperty("OutTransportInfo"));
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void handleIncomingMessage(MessageContext msgCtx, Map trpHeaders, String soapAction, String contentType) {
        if (soapAction != null) {
            msgCtx.setSoapAction(soapAction);
        }
        msgCtx.setProperty("TRANSPORT_HEADERS", trpHeaders);
        try {
            try {
                AxisEngine.receive(msgCtx);
            }
            catch (AxisFault e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Error receiving message", e);
                }
                if (msgCtx.isServerSide()) {
                    AxisEngine.sendFault(MessageContextBuilder.createFaultMessageContext(msgCtx, e));
                }
            }
        }
        catch (AxisFault axisFault) {
            this.logException("Error processing response message", axisFault);
        }
    }

    public MessageContext createResponseMessageContext(MessageContext outMsgCtx) {
        MessageContext responseMsgCtx = null;
        try {
            responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
        }
        catch (AxisFault af) {
            this.log.error("Error getting IN message context from the operation context", af);
        }
        if (responseMsgCtx == null) {
            responseMsgCtx = new MessageContext();
            responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        }
        responseMsgCtx.setIncomingTransportName(this.getTransportName());
        responseMsgCtx.setTransportOut(this.transportOut);
        responseMsgCtx.setTransportIn(this.transportIn);
        responseMsgCtx.setMessageID(UUIDGenerator.getUUID());
        responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
        responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
        responseMsgCtx.setAxisMessage(outMsgCtx.getOperationContext().getAxisOperation().getMessage("In"));
        responseMsgCtx.setTo(null);
        return responseMsgCtx;
    }

    protected boolean waitForSynchronousResponse(MessageContext msgCtx) {
        return msgCtx.getOperationContext() != null && "http://www.w3.org/ns/wsdl/out-in".equals(msgCtx.getOperationContext().getAxisOperation().getMessageExchangePattern());
    }

    public String getTransportName() {
        return this.transportOut.getName();
    }

    protected void handleException(String msg, Exception e) throws AxisFault {
        this.log.error(msg, e);
        throw new AxisFault(msg, e);
    }

    protected void handleException(String msg) throws AxisFault {
        this.log.error(msg);
        throw new AxisFault(msg);
    }

    protected void logException(String msg, Exception e) {
        this.log.error(msg, e);
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        this.log.info("Sender paused");
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        this.state = 1;
        this.log.info("Sender resumed");
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        long start = System.currentTimeMillis();
        this.stop();
        this.state = 0;
        this.log.info("Sender shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s");
    }

    public int getActiveThreadCount() {
        return 0;
    }

    public int getQueueSize() {
        return 0;
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    public long getTimeoutsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsReceiving();
        }
        return -1L;
    }

    public long getTimeoutsSending() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsSending();
        }
        return -1L;
    }

    public long getMinSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeReceived();
        }
        return -1L;
    }

    public long getMaxSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeReceived();
        }
        return -1L;
    }

    public double getAvgSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeReceived();
        }
        return -1.0;
    }

    public long getMinSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeSent();
        }
        return -1L;
    }

    public long getMaxSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeSent();
        }
        return -1L;
    }

    public double getAvgSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeSent();
        }
        return -1.0;
    }

    public Map getResponseCodeTable() {
        if (this.metrics != null) {
            return this.metrics.getResponseCodeTable();
        }
        return null;
    }

    public void resetStatistics() {
        if (this.metrics != null) {
            this.metrics.reset();
        }
    }

    public long getLastResetTime() {
        if (this.metrics != null) {
            return this.metrics.getLastResetTime();
        }
        return -1L;
    }

    public long getMetricsWindow() {
        if (this.metrics != null) {
            return System.currentTimeMillis() - this.metrics.getLastResetTime();
        }
        return -1L;
    }

    private void registerMBean(MBeanServer mbs, Object mbeanInstance, String objectName) {
        try {
            ObjectName name = new ObjectName(objectName);
            Set<ObjectName> set = mbs.queryNames(name, null);
            if (set != null && set.isEmpty()) {
                mbs.registerMBean(mbeanInstance, name);
            } else {
                mbs.unregisterMBean(name);
                mbs.registerMBean(mbeanInstance, name);
            }
        }
        catch (Exception e) {
            this.log.warn("Error registering a MBean with objectname ' " + objectName + " ' for JMX management", e);
        }
    }
}

