/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.receivers;

import java.net.URL;
import java.security.PrivilegedAction;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.classloader.MultiParentClassLoader;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.Utils;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMessageReceiver
implements MessageReceiver {
    protected static final Log log = LogFactory.getLog(AbstractMessageReceiver.class);
    public static final String SCOPE = "scope";
    protected String serviceTCCL = null;
    public static final String SAVED_TCCL = "_SAVED_TCCL_";
    public static final String SAVED_MC = "_SAVED_MC_";
    public static final String DO_ASYNC = "messageReceiver.invokeOnSeparateThread";

    protected void replicateState(MessageContext messageContext) throws ClusteringFault {
        Replicator.replicate(messageContext);
    }

    protected abstract void invokeBusinessLogic(MessageContext var1) throws AxisFault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(MessageContext messageCtx) throws AxisFault {
        block8: {
            if (messageCtx.isPropertyTrue(DO_ASYNC) || messageCtx.getParameter(DO_ASYNC) != null && JavaUtils.isTrueExplicitly(messageCtx.getParameter(DO_ASYNC).getValue())) {
                String mep = messageCtx.getAxisOperation().getMessageExchangePattern();
                EndpointReference replyTo = messageCtx.getReplyTo();
                if (!WSDLUtil.isOutputPresentForMEP(mep) || replyTo != null && !replyTo.hasAnonymousAddress()) {
                    AsyncMessageReceiverWorker worker = new AsyncMessageReceiverWorker(messageCtx);
                    messageCtx.getEnvelope().build();
                    messageCtx.getConfigurationContext().getThreadPool().execute(worker);
                    return;
                }
            }
            ThreadContextDescriptor tc = this.setThreadContext(messageCtx);
            try {
                this.invokeBusinessLogic(messageCtx);
            }
            catch (AxisFault fault) {
                messageCtx.setProperty("SET_ROLLBACK_ONLY", true);
                if (messageCtx.getAxisOperation() instanceof InOnlyAxisOperation && !"http://www.w3.org/ns/wsdl/robust-in-only".equals(messageCtx.getAxisOperation().getMessageExchangePattern())) {
                    log.error(fault);
                    break block8;
                }
                fault.setFaultType(1);
                throw fault;
            }
            finally {
                this.restoreThreadContext(tc);
            }
        }
    }

    protected ThreadContextDescriptor setThreadContext(final MessageContext msgContext) {
        ClassLoader contextClassLoader;
        ThreadContextDescriptor tc = new ThreadContextDescriptor();
        tc.oldMessageContext = MessageContext.currentMessageContext.get();
        tc.oldClassLoader = contextClassLoader = this.getContextClassLoader_doPriv();
        AxisService service = msgContext.getAxisService();
        String serviceTCCL = (String)service.getParameterValue("ServiceTCCL");
        if (serviceTCCL != null) {
            if ((serviceTCCL = serviceTCCL.trim().toLowerCase()).equals("composite")) {
                final ClassLoader loader = (ClassLoader)java.security.AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new MultiParentClassLoader(new URL[0], new ClassLoader[]{msgContext.getAxisService().getClassLoader(), contextClassLoader});
                    }
                });
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(loader);
                        return null;
                    }
                });
            } else if (serviceTCCL.equals("service")) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(msgContext.getAxisService().getClassLoader());
                        return null;
                    }
                });
            }
        }
        MessageContext.setCurrentMessageContext(msgContext);
        return tc;
    }

    private ClassLoader getContextClassLoader_doPriv() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    protected void restoreThreadContext(final ThreadContextDescriptor tc) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(tc.oldClassLoader);
                return null;
            }
        });
        MessageContext.currentMessageContext.set(tc.oldMessageContext);
    }

    protected Object makeNewServiceObject(MessageContext msgContext) throws AxisFault {
        Object serviceObject = Utils.createServiceObject(msgContext.getAxisService());
        if (serviceObject == null) {
            throw new AxisFault(Messages.getMessage("paramIsNotSpecified", "SERVICE_OBJECT_SUPPLIER"));
        }
        return serviceObject;
    }

    public SOAPFactory getSOAPFactory(MessageContext msgContext) throws AxisFault {
        String nsURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage("invalidSOAPversion"));
    }

    protected Object getTheImplementationObject(MessageContext msgContext) throws AxisFault {
        ServiceContext serviceContext = msgContext.getServiceContext();
        Object serviceimpl = serviceContext.getProperty("serviceObject");
        if (serviceimpl != null) {
            return serviceimpl;
        }
        serviceimpl = this.makeNewServiceObject(msgContext);
        DependencyManager.initServiceObject(serviceimpl, msgContext.getServiceContext());
        serviceContext.setProperty("serviceObject", serviceimpl);
        return serviceimpl;
    }

    public class AsyncMessageReceiverWorker
    implements Runnable {
        private MessageContext messageCtx;

        public AsyncMessageReceiverWorker(MessageContext messageCtx) {
            this.messageCtx = messageCtx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ThreadContextDescriptor tc = AbstractMessageReceiver.this.setThreadContext(this.messageCtx);
                try {
                    AbstractMessageReceiver.this.invokeBusinessLogic(this.messageCtx);
                }
                finally {
                    AbstractMessageReceiver.this.restoreThreadContext(tc);
                }
            }
            catch (AxisFault e) {
                if (this.messageCtx.getAxisOperation() instanceof InOnlyAxisOperation) {
                    log.debug(e.getMessage(), e);
                }
                try {
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(this.messageCtx, e);
                    AxisEngine.sendFault(faultContext);
                }
                catch (AxisFault axisFault) {
                    log.error(e.getMessage(), e);
                }
                log.error(e.getMessage(), e);
            }
        }
    }

    public static class ThreadContextDescriptor {
        public ClassLoader oldClassLoader;
        public MessageContext oldMessageContext;
    }
}

