/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.wso2.andes.configuration.Validator;

public interface Accessor {
    public Boolean getBoolean(String var1);

    public Integer getInt(String var1);

    public Long getLong(String var1);

    public String getString(String var1);

    public static class ValidationAccessor
    implements Accessor {
        private List<Validator> validators;
        private Accessor delegate;

        public ValidationAccessor(Accessor delegate, Validator ... validators) {
            this.validators = Arrays.asList(validators);
            this.delegate = delegate;
        }

        public Boolean getBoolean(String name) {
            return this.delegate.getBoolean(name);
        }

        public Integer getInt(String name) {
            Integer v = this.delegate.getInt(name);
            for (Validator validator : this.validators) {
                validator.validate(v);
            }
            return v;
        }

        public Long getLong(String name) {
            Long v = this.delegate.getLong(name);
            for (Validator validator : this.validators) {
                validator.validate(v);
            }
            return v;
        }

        public String getString(String name) {
            String v = this.delegate.getString(name);
            for (Validator validator : this.validators) {
                validator.validate(v);
            }
            return v;
        }
    }

    public static class CombinedAccessor
    implements Accessor {
        private List<Accessor> accessors;

        public CombinedAccessor(Accessor ... accessors) {
            this.accessors = Arrays.asList(accessors);
        }

        public Boolean getBoolean(String name) {
            for (Accessor accessor : this.accessors) {
                if (accessor.getBoolean(name) == null) continue;
                return accessor.getBoolean(name);
            }
            return null;
        }

        public Integer getInt(String name) {
            for (Accessor accessor : this.accessors) {
                if (accessor.getBoolean(name) == null) continue;
                return accessor.getInt(name);
            }
            return null;
        }

        public Long getLong(String name) {
            for (Accessor accessor : this.accessors) {
                if (accessor.getBoolean(name) == null) continue;
                return accessor.getLong(name);
            }
            return null;
        }

        public String getString(String name) {
            for (Accessor accessor : this.accessors) {
                if (accessor.getBoolean(name) == null) continue;
                return accessor.getString(name);
            }
            return null;
        }
    }

    public static class PropertyFileAccessor
    extends MapAccessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PropertyFileAccessor(String fileName) throws FileNotFoundException, IOException {
            super(null);
            Properties props = new Properties();
            FileInputStream inStream = new FileInputStream(fileName);
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            this.source = props;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapAccessor
    implements Accessor {
        protected Map<Object, Object> source;

        public MapAccessor(Map<Object, Object> map) {
            this.source = map;
        }

        @Override
        public Boolean getBoolean(String name) {
            if (this.source != null && this.source.containsKey(name)) {
                if (this.source.get(name) instanceof Boolean) {
                    return (Boolean)this.source.get(name);
                }
                return Boolean.parseBoolean((String)this.source.get(name));
            }
            return null;
        }

        @Override
        public Integer getInt(String name) {
            if (this.source != null && this.source.containsKey(name)) {
                if (this.source.get(name) instanceof Integer) {
                    return (Integer)this.source.get(name);
                }
                return Integer.parseInt((String)this.source.get(name));
            }
            return null;
        }

        @Override
        public Long getLong(String name) {
            if (this.source != null && this.source.containsKey(name)) {
                if (this.source.get(name) instanceof Long) {
                    return (Long)this.source.get(name);
                }
                return Long.parseLong((String)this.source.get(name));
            }
            return null;
        }

        @Override
        public String getString(String name) {
            if (this.source != null && this.source.containsKey(name)) {
                if (this.source.get(name) instanceof String) {
                    return (String)this.source.get(name);
                }
                return String.valueOf(this.source.get(name));
            }
            return null;
        }
    }

    public static class SystemPropertyAccessor
    implements Accessor {
        public Boolean getBoolean(String name) {
            return Boolean.getBoolean(name);
        }

        public Integer getInt(String name) {
            return Integer.getInteger(name);
        }

        public Long getLong(String name) {
            return Long.getLong(name);
        }

        public String getString(String name) {
            return System.getProperty(name);
        }
    }
}

