/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.url;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.wso2.andes.client.AMQBrokerDetails;
import org.wso2.andes.jms.BrokerDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLParser_0_10 {
    private static final char[] URL_START_SEQ = new char[]{'q', 'p', 'i', 'd', ':'};
    private static final char PROPERTY_EQUALS_CHAR = '=';
    private static final char PROPERTY_SEPARATOR_CHAR = ';';
    private static final char ADDRESS_SEPERATOR_CHAR = ',';
    private static final char TRANSPORT_HOST_SEPARATOR_CHAR = ':';
    private static final char HOST_PORT_SEPARATOR_CHAR = ':';
    private static final char AT_CHAR = '@';
    private static final char END_OF_URL_MARKER = '^';
    private char[] _url;
    private List<BrokerDetails> _brokerDetailList = new ArrayList<BrokerDetails>();
    private String _error;
    private int _index = 0;
    private BrokerDetails _currentBroker;
    private String _currentPropName;
    private boolean _endOfURL = false;
    private URLParserState _currentParserState;

    public URLParser_0_10(String url) throws MalformedURLException {
        this._url = (url + '^').toCharArray();
        this._endOfURL = false;
        URLParserState prevState = this._currentParserState = URLParserState.QPID_URL_START;
        try {
            while (this._currentParserState != URLParserState.ERROR && this._currentParserState != URLParserState.QPID_URL_END) {
                prevState = this._currentParserState;
                this._currentParserState = this.next();
            }
            if (this._currentParserState == URLParserState.ERROR) {
                this._error = "Invalid URL format [current_state = " + (Object)((Object)prevState) + ", broker details parsed so far " + this._currentBroker + " ] error at (" + this._index + ") due to " + this._error;
                MalformedURLException ex = new MalformedURLException(this._error);
                throw ex;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this._error = "Invalid URL format [current_state = " + (Object)((Object)prevState) + ", broker details parsed so far " + this._currentBroker + " ] error at (" + this._index + ")";
            MalformedURLException ex = new MalformedURLException(this._error);
            throw ex;
        }
    }

    public List<BrokerDetails> getAllBrokerDetails() {
        return this._brokerDetailList;
    }

    public String getURL() {
        return new String(this._url);
    }

    private URLParserState next() {
        switch (this._currentParserState) {
            case QPID_URL_START: {
                return this.checkSequence(URL_START_SEQ, URLParserState.ADDRESS_START);
            }
            case ADDRESS_START: {
                return this.startAddress();
            }
            case PROPERTY_NAME: {
                return this.extractPropertyName();
            }
            case PROPERTY_EQUALS: {
                ++this._index;
                return URLParserState.PROPERTY_VALUE;
            }
            case PROPERTY_VALUE: {
                return this.extractPropertyValue();
            }
            case PROPERTY_SEPARATOR: {
                ++this._index;
                return URLParserState.PROPERTY_NAME;
            }
            case AT_CHAR: {
                ++this._index;
                return URLParserState.TRANSPORT;
            }
            case TRANSPORT: {
                return this.extractTransport();
            }
            case TRANSPORT_HOST_SEPARATOR: {
                ++this._index;
                return URLParserState.HOST;
            }
            case HOST: {
                return this.extractHost();
            }
            case HOST_PORT_SEPARATOR: {
                ++this._index;
                return URLParserState.PORT;
            }
            case PORT: {
                return this.extractPort();
            }
            case ADDRESS_END: {
                return this.endAddress();
            }
            case ADDRESS_SEPERATOR: {
                ++this._index;
                return URLParserState.ADDRESS_START;
            }
        }
        return URLParserState.ERROR;
    }

    private URLParserState checkSequence(char[] expected, URLParserState nextPart) {
        for (char expectedChar : expected) {
            if (expectedChar != this._url[this._index]) {
                this._error = "Excepted (" + expectedChar + ") at position " + this._index + ", got (" + this._url[this._index] + ")";
                return URLParserState.ERROR;
            }
            ++this._index;
        }
        return nextPart;
    }

    private URLParserState startAddress() {
        this._currentBroker = new AMQBrokerDetails();
        for (int j = this._index; j < this._url.length; ++j) {
            if (this._url[j] == '=') {
                return URLParserState.PROPERTY_NAME;
            }
            if (this._url[j] != ',') continue;
            return URLParserState.TRANSPORT;
        }
        return URLParserState.TRANSPORT;
    }

    private URLParserState endAddress() {
        this._brokerDetailList.add(this._currentBroker);
        if (this._endOfURL) {
            return URLParserState.QPID_URL_END;
        }
        return URLParserState.ADDRESS_SEPERATOR;
    }

    private URLParserState extractPropertyName() {
        StringBuilder b = new StringBuilder();
        char next = this._url[this._index];
        while (next != '=' && next != '@') {
            b.append(next);
            next = this._url[++this._index];
        }
        this._currentPropName = b.toString();
        if (this._currentPropName.trim().equals("")) {
            this._error = "Property name cannot be empty";
            return URLParserState.ERROR;
        }
        if (next == '=') {
            return URLParserState.PROPERTY_EQUALS;
        }
        return URLParserState.AT_CHAR;
    }

    private URLParserState extractPropertyValue() {
        StringBuilder b = new StringBuilder();
        char next = this._url[this._index];
        while (next != ';' && next != '@') {
            b.append(next);
            next = this._url[++this._index];
        }
        String propValue = b.toString();
        if (propValue.trim().equals("")) {
            this._error = "Property values cannot be empty";
            return URLParserState.ERROR;
        }
        this._currentBroker.setProperty(this._currentPropName, propValue);
        if (next == ';') {
            return URLParserState.PROPERTY_SEPARATOR;
        }
        return URLParserState.AT_CHAR;
    }

    private URLParserState extractTransport() {
        String transport = this.buildUntil(':');
        if (transport.trim().equals("")) {
            this._error = "Transport cannot be empty";
            return URLParserState.ERROR;
        }
        if (!transport.trim().equals("tcp") && !transport.trim().equals("tls")) {
            this._error = "Transport cannot be " + transport + " value must be tcp or tls";
            return URLParserState.ERROR;
        }
        this._currentBroker.setTransport(transport);
        return URLParserState.TRANSPORT_HOST_SEPARATOR;
    }

    private URLParserState extractHost() {
        URLParserState nextState;
        String host;
        int nextSep = 99;
        for (int i = this._index; i < this._url.length; ++i) {
            if (this._url[i] == ':') {
                nextSep = 58;
                break;
            }
            if (this._url[i] != ',') continue;
            nextSep = 44;
            break;
        }
        if (nextSep == 58) {
            host = this.buildUntil(':');
            nextState = URLParserState.HOST_PORT_SEPARATOR;
        } else if (nextSep == 44) {
            host = this.buildUntil(',');
            nextState = URLParserState.ADDRESS_END;
        } else {
            host = this.buildUntil('^');
            nextState = URLParserState.ADDRESS_END;
            this._endOfURL = true;
        }
        if (host.trim().equals("")) {
            this._error = "Host cannot be empty";
            return URLParserState.ERROR;
        }
        this._currentBroker.setHost(host);
        return nextState;
    }

    private URLParserState extractPort() {
        StringBuilder b = new StringBuilder();
        try {
            char next = this._url[this._index];
            while (next != ',' && next != '^') {
                b.append(next);
                next = this._url[++this._index];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this._endOfURL = true;
        }
        String portStr = b.toString();
        if (portStr.trim().equals("")) {
            this._error = "Host cannot be empty";
            return URLParserState.ERROR;
        }
        try {
            int port = Integer.parseInt(portStr);
            this._currentBroker.setPort(port);
            if (this._url[this._index] == '^') {
                this._endOfURL = true;
            }
            return URLParserState.ADDRESS_END;
        }
        catch (NumberFormatException e) {
            this._error = "Illegal number for port";
            return URLParserState.ERROR;
        }
    }

    private String buildUntil(char c) {
        StringBuilder b = new StringBuilder();
        char next = this._url[this._index];
        while (next != c) {
            b.append(next);
            next = this._url[++this._index];
        }
        return b.toString();
    }

    public static void main(String[] args) {
        String testurl = "qpid:password=pass;username=name@tcp:test1";
        try {
            URLParser_0_10 impl = new URLParser_0_10(testurl);
            for (BrokerDetails d : impl.getAllBrokerDetails()) {
                System.out.println(d);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum URLParserState {
        QPID_URL_START,
        ADDRESS_START,
        PROPERTY_NAME,
        PROPERTY_EQUALS,
        PROPERTY_VALUE,
        PROPERTY_SEPARATOR,
        AT_CHAR,
        TRANSPORT,
        TRANSPORT_HOST_SEPARATOR,
        HOST,
        HOST_PORT_SEPARATOR,
        PORT,
        ADDRESS_END,
        ADDRESS_SEPERATOR,
        QPID_URL_END,
        ERROR;

    }
}

