/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.geom.Rectangle2D;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.hslf.model.AutoShapes;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.ShapeOutline;
import org.apache.poi.hslf.model.ShapeTypes;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.TextShape;

public class AutoShape
extends TextShape {
    protected AutoShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public AutoShape(int type, Shape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(type, parent instanceof ShapeGroup);
    }

    public AutoShape(int type) {
        this(type, null);
    }

    protected EscherContainerRecord createSpContainer(int shapeType, boolean isChild) {
        this._escherContainer = super.createSpContainer(isChild);
        this.setShapeType(shapeType);
        this.setEscherProperty((short)127, 262144);
        this.setEscherProperty((short)385, 0x8000004);
        this.setEscherProperty((short)385, 0x8000004);
        this.setEscherProperty((short)387, 0x8000000);
        this.setEscherProperty((short)447, 0x100010);
        this.setEscherProperty((short)448, 0x8000001);
        this.setEscherProperty((short)511, 524296);
        this.setEscherProperty((short)513, 0x8000002);
        return this._escherContainer;
    }

    protected void setDefaultTextProperties(TextRun _txtrun) {
        this.setVerticalAlignment(1);
        this.setHorizontalAlignment(1);
        this.setWordWrap(2);
    }

    public int getAdjustmentValue(int idx) {
        if (idx < 0 || idx > 9) {
            throw new IllegalArgumentException("The index of an adjustment value must be in the [0, 9] range");
        }
        return this.getEscherProperty((short)(327 + idx));
    }

    public void setAdjustmentValue(int idx, int val) {
        if (idx < 0 || idx > 9) {
            throw new IllegalArgumentException("The index of an adjustment value must be in the [0, 9] range");
        }
        this.setEscherProperty((short)(327 + idx), val);
    }

    public java.awt.Shape getOutline() {
        ShapeOutline outline = AutoShapes.getShapeOutline(this.getShapeType());
        Rectangle2D anchor = this.getLogicalAnchor2D();
        if (outline == null) {
            this.logger.log(5, "Outline not found for " + ShapeTypes.typeName(this.getShapeType()));
            return anchor;
        }
        java.awt.Shape shape = outline.getOutline(this);
        return AutoShapes.transform(shape, anchor);
    }
}

