/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.statistics.publisher.wso2.cep;

import java.io.File;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.statistics.publisher.wso2.cep.ThriftClientConfig;
import org.apache.stratos.common.statistics.publisher.wso2.cep.ThriftClientInfo;
import org.apache.stratos.common.util.AxiomXpathParserUtil;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class ThriftClientConfigParser {
    private static final Log log = LogFactory.getLog(ThriftClientConfigParser.class);
    private static final String USERNAME_ELEMENT = "username";
    private static final String PASSWORD_ELEMENT = "password";
    private static final String IP_ELEMENT = "ip";
    private static final String PORT_ELEMENT = "port";

    public static ThriftClientConfig parse(String filePath) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Parsing thrift client config file: %s", filePath));
            }
            ThriftClientConfig thriftClientIConfig = new ThriftClientConfig();
            ThriftClientInfo thriftClientInfo = new ThriftClientInfo();
            thriftClientIConfig.setThriftClientInfo(thriftClientInfo);
            File configFile = new File(filePath);
            if (!configFile.exists()) {
                throw new RuntimeException(String.format("Thrift client config file does not exist: %s", filePath));
            }
            OMElement document = AxiomXpathParserUtil.parse(configFile);
            Iterator thriftClientIterator = document.getChildElements();
            SecretResolver secretResolver = SecretResolverFactory.create((OMElement)document, (boolean)false);
            String userNameValuesStr = null;
            String passwordValueStr = null;
            String ipValuesStr = null;
            String portValueStr = null;
            String secretAlias = "thrift.client.configuration.password";
            while (thriftClientIterator.hasNext()) {
                OMElement thriftClientElement = (OMElement)thriftClientIterator.next();
                if (USERNAME_ELEMENT.equals(thriftClientElement.getQName().getLocalPart())) {
                    userNameValuesStr = thriftClientElement.getText();
                    thriftClientInfo.setUsername(userNameValuesStr);
                }
                if (PASSWORD_ELEMENT.equals(thriftClientElement.getQName().getLocalPart())) {
                    passwordValueStr = secretResolver != null && secretResolver.isInitialized() ? (secretResolver.isTokenProtected(secretAlias) ? secretResolver.resolve(secretAlias) : thriftClientElement.getText()) : thriftClientElement.getText();
                    thriftClientInfo.setPassword(passwordValueStr);
                }
                if (IP_ELEMENT.equals(thriftClientElement.getQName().getLocalPart())) {
                    ipValuesStr = thriftClientElement.getText();
                    thriftClientInfo.setIp(ipValuesStr);
                }
                if (!PORT_ELEMENT.equals(thriftClientElement.getQName().getLocalPart())) continue;
                portValueStr = thriftClientElement.getText();
                thriftClientInfo.setPort(portValueStr);
            }
            if (userNameValuesStr == null) {
                throw new RuntimeException("Username value not found in thrift client configuration");
            }
            if (passwordValueStr == null) {
                throw new RuntimeException("Password not found in thrift client configuration ");
            }
            if (ipValuesStr == null) {
                throw new RuntimeException("Ip values not found in thrift client configuration ");
            }
            if (portValueStr == null) {
                throw new RuntimeException("Port not found in thrift client configuration ");
            }
            return thriftClientIConfig;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse thrift client configuration", e);
        }
    }
}

