/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.processors;

import java.io.IOException;
import java.util.Collection;
import org.apache.abdera.protocol.server.CategoriesInfo;
import org.apache.abdera.protocol.server.CategoryInfo;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.RequestProcessor;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.WorkspaceManager;
import org.apache.abdera.protocol.server.context.StreamWriterResponseContext;
import org.apache.abdera.writer.StreamWriter;

public class ServiceRequestProcessor
implements RequestProcessor {
    public ResponseContext process(RequestContext context, WorkspaceManager workspaceManager, CollectionAdapter collectionAdapter) {
        return this.processService(context, workspaceManager);
    }

    private ResponseContext processService(RequestContext context, WorkspaceManager workspaceManager) {
        String method = context.getMethod();
        if (method.equalsIgnoreCase("GET")) {
            return this.getServiceDocument(context, workspaceManager);
        }
        return null;
    }

    protected ResponseContext getServiceDocument(final RequestContext request, final WorkspaceManager workspaceManager) {
        return new StreamWriterResponseContext(request.getAbdera()){

            protected void writeTo(StreamWriter sw) throws IOException {
                sw.startDocument().startService();
                for (WorkspaceInfo wi : workspaceManager.getWorkspaces(request)) {
                    sw.startWorkspace().writeTitle(wi.getTitle(request));
                    Collection<CollectionInfo> collections = wi.getCollections(request);
                    if (collections != null) {
                        for (CollectionInfo ci : collections) {
                            sw.startCollection(ci.getHref(request)).writeTitle(ci.getTitle(request)).writeAccepts(ci.getAccepts(request));
                            CategoriesInfo[] catinfos = ci.getCategoriesInfo(request);
                            if (catinfos != null) {
                                for (CategoriesInfo catinfo : catinfos) {
                                    String cathref = catinfo.getHref(request);
                                    if (cathref != null) {
                                        sw.startCategories().writeAttribute("href", request.getTargetBasePath() + cathref).endCategories();
                                        continue;
                                    }
                                    sw.startCategories(catinfo.isFixed(request), catinfo.getScheme(request));
                                    for (CategoryInfo cat : catinfo) {
                                        sw.writeCategory(cat.getTerm(request), cat.getScheme(request), cat.getLabel(request));
                                    }
                                    sw.endCategories();
                                }
                            }
                            sw.endCollection();
                        }
                    }
                    sw.endWorkspace();
                }
                sw.endService().endDocument();
            }
        }.setStatus(200).setContentType("application/atomsvc+xml");
    }
}

