/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.nclient.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.wso2.andes.api.Message;
import org.wso2.andes.transport.DeliveryProperties;
import org.wso2.andes.transport.Header;
import org.wso2.andes.transport.MessageProperties;

public class ByteBufferMessage
implements Message {
    private List<ByteBuffer> _data;
    private ByteBuffer _readBuffer;
    private int _dataSize;
    private DeliveryProperties _currentDeliveryProps;
    private MessageProperties _currentMessageProps;
    private int _transferId;
    private Header _header;

    public ByteBufferMessage(MessageProperties messageProperties, DeliveryProperties deliveryProperties) {
        this._currentMessageProps = messageProperties;
        this._currentDeliveryProps = deliveryProperties;
    }

    public void setHeader(Header header) {
        this._header = header;
    }

    public Header getHeader() {
        return this._header;
    }

    public ByteBufferMessage() {
        this._currentDeliveryProps = new DeliveryProperties();
        this._currentMessageProps = new MessageProperties();
    }

    public ByteBufferMessage(int transferId) {
        this._transferId = transferId;
    }

    public int getMessageTransferId() {
        return this._transferId;
    }

    public void clearData() {
        this._data = new LinkedList<ByteBuffer>();
        this._readBuffer = null;
    }

    public void appendData(byte[] src) throws IOException {
        this.appendData(ByteBuffer.wrap(src));
    }

    public void appendData(ByteBuffer src) throws IOException {
        if (this._data == null) {
            this._data = Collections.singletonList(src);
        } else {
            if (this._data.size() == 1) {
                this._data = new ArrayList<ByteBuffer>(this._data);
            }
            this._data.add(src);
        }
        this._dataSize += src.remaining();
    }

    public DeliveryProperties getDeliveryProperties() {
        return this._currentDeliveryProps;
    }

    public MessageProperties getMessageProperties() {
        return this._currentMessageProps;
    }

    public void setDeliveryProperties(DeliveryProperties props) {
        this._currentDeliveryProps = props;
    }

    public void setMessageProperties(MessageProperties props) {
        this._currentMessageProps = props;
    }

    public void readData(byte[] target) {
        this.getReadBuffer().get(target);
    }

    public ByteBuffer readData() {
        return this.getReadBuffer();
    }

    private void buildReadBuffer() {
        if (this._data.size() == 1) {
            this._readBuffer = this._data.get(0).duplicate();
        } else {
            this._readBuffer = ByteBuffer.allocate(this._dataSize);
            for (ByteBuffer buf : this._data) {
                this._readBuffer.put(buf);
            }
            this._readBuffer.flip();
        }
    }

    private ByteBuffer getReadBuffer() {
        if (this._readBuffer != null) {
            return this._readBuffer.slice();
        }
        if (this._data.size() > 0) {
            this.buildReadBuffer();
            return this._readBuffer.slice();
        }
        return ByteBuffer.allocate(0);
    }

    public String toString() {
        ByteBuffer temp = this.getReadBuffer();
        byte[] b = new byte[temp.remaining()];
        temp.get(b);
        return new String(b);
    }
}

