/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.QueueDeclareOkBody;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class QueueDeclareOkBodyImpl
extends AMQMethodBody_8_0
implements QueueDeclareOkBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new QueueDeclareOkBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 11;
    private final AMQShortString _queue;
    private final long _messageCount;
    private final long _consumerCount;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public QueueDeclareOkBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._queue = this.readAMQShortString(buffer);
        this._messageCount = this.readUnsignedInteger(buffer);
        this._consumerCount = this.readUnsignedInteger(buffer);
    }

    public QueueDeclareOkBodyImpl(AMQShortString queue, long messageCount, long consumerCount) {
        this._queue = queue;
        this._messageCount = messageCount;
        this._consumerCount = consumerCount;
    }

    public int getClazz() {
        return 50;
    }

    public int getMethod() {
        return 11;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final long getMessageCount() {
        return this._messageCount;
    }

    public final long getConsumerCount() {
        return this._consumerCount;
    }

    protected int getBodySize() {
        int size = 8;
        return size += this.getSizeOf(this._queue);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._queue);
        this.writeUnsignedInteger(buffer, this._messageCount);
        this.writeUnsignedInteger(buffer, this._consumerCount);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchQueueDeclareOk(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeclareOkBodyImpl: ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("messageCount=");
        buf.append(this.getMessageCount());
        buf.append(", ");
        buf.append("consumerCount=");
        buf.append(this.getConsumerCount());
        buf.append("]");
        return buf.toString();
    }
}

