/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQBody;
import org.wso2.andes.framing.AMQFrame;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.protocol.AMQVersionAwareProtocolSession;

public class HeartbeatBody
implements AMQBody {
    public static final byte TYPE = 8;
    public static final AMQFrame FRAME = new HeartbeatBody().toFrame();

    public HeartbeatBody() {
    }

    public HeartbeatBody(ByteBuffer buffer, long size) {
        if (size > 0L) {
            buffer.skip((int)size);
        }
    }

    public byte getFrameType() {
        return 8;
    }

    public int getSize() {
        return 0;
    }

    public void writePayload(ByteBuffer buffer) {
    }

    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws AMQException {
        session.heartbeatBodyReceived(channelId, this);
    }

    protected void populateFromBuffer(ByteBuffer buffer, long size) throws AMQFrameDecodingException {
        if (size > 0L) {
            buffer.skip((int)size);
        }
    }

    public AMQFrame toFrame() {
        return new AMQFrame(0, this);
    }
}

