/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.protocol;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeartbeatConfig {
    private static final Logger _logger = LoggerFactory.getLogger(HeartbeatConfig.class);
    static final HeartbeatConfig CONFIG = new HeartbeatConfig();
    private float timeoutFactor = 2.0f;

    HeartbeatConfig() {
        String property = System.getProperty("amqj.heartbeat.timeoutFactor");
        if (property != null) {
            try {
                this.timeoutFactor = Float.parseFloat(property);
            }
            catch (NumberFormatException e) {
                _logger.warn("Invalid timeout factor (amqj.heartbeat.timeoutFactor): " + property);
            }
        }
    }

    float getTimeoutFactor() {
        return this.timeoutFactor;
    }

    int getTimeout(int writeDelay) {
        return (int)(this.timeoutFactor * (float)writeDelay);
    }
}

