/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.agent.thrift.conf.AgentConfiguration;

public final class AgentBuilder {
    private static final Log log = LogFactory.getLog(AgentBuilder.class);

    private AgentBuilder() {
    }

    public static AgentConfiguration loadAgentConfiguration(AgentConfiguration agentConfiguration) {
        OMElement agentConfig = AgentBuilder.loadConfigXML();
        if (agentConfig != null) {
            if (!agentConfig.getQName().equals(new QName("http://wso2.org/carbon/databridge/agent/thrift", "thriftAgentConfiguration"))) {
                log.error((Object)"Invalid root element in agent config");
            }
            return AgentBuilder.buildAgentConfiguration(agentConfig);
        }
        return agentConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OMElement loadConfigXML() {
        String errorMessage;
        String carbonHome = System.getProperty("carbon.config.dir.path");
        String path = carbonHome + File.separator + "data-bridge" + File.separator + "thrift-agent-config.xml";
        File agentConfigFile = new File(path);
        if (!agentConfigFile.exists()) {
            return null;
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            errorMessage = "thrift-agent-config.xmlcannot be found in the path : " + path;
            log.error((Object)errorMessage, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String errorMessage2 = "Invalid XML for thrift-agent-config.xml located in the path : " + path;
            log.error((Object)errorMessage2, (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                errorMessage = "Can not close the input stream";
                log.error((Object)errorMessage, (Throwable)e);
            }
        }
        return null;
    }

    private static AgentConfiguration buildAgentConfiguration(OMElement agentServerConfig) {
        AgentConfiguration agentConfiguration = new AgentConfiguration();
        AgentBuilder.buildReceiverConfiguration(agentServerConfig, agentConfiguration);
        AgentBuilder.buildKeyStoreConfiguration(agentServerConfig, agentConfiguration);
        return agentConfiguration;
    }

    private static void buildReceiverConfiguration(OMElement agentServerConfig, AgentConfiguration agentConfiguration) {
        OMElement reconnectionInterval;
        OMElement lbBuffer;
        OMElement asyncBuffer;
        OMElement secureMinIdleTimeInPool;
        OMElement secureMaxTransportPoolSize;
        OMElement secureMaxIdleConnections;
        OMElement secureEvictionTimePeriod;
        OMElement evictionTimePeriod;
        OMElement maxPoolSize;
        OMElement poolSize;
        OMElement bufferedEventsSize;
        OMElement minIdleTimeInPool;
        OMElement maxMessageBundleSize;
        OMElement maxIdleConnections;
        OMElement maxTransportPoolSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "maxTransportPoolSize"));
        if (maxTransportPoolSize != null) {
            agentConfiguration.setMaxTransportPoolSize(Integer.parseInt(maxTransportPoolSize.getText()));
        }
        if ((maxIdleConnections = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "maxIdleConnections"))) != null) {
            agentConfiguration.setMaxIdleConnections(Integer.parseInt(maxIdleConnections.getText()));
        }
        if ((maxMessageBundleSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "maxMessageBundleSize"))) != null) {
            agentConfiguration.setMaxMessageBundleSize(Integer.parseInt(maxMessageBundleSize.getText()));
        }
        if ((minIdleTimeInPool = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "minIdleTimeInPool"))) != null) {
            agentConfiguration.setMinIdleTimeInPool(Integer.parseInt(minIdleTimeInPool.getText()));
        }
        if ((bufferedEventsSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "bufferedEventsSize"))) != null) {
            agentConfiguration.setBufferedEventsSize(Integer.parseInt(bufferedEventsSize.getText()));
        }
        if ((poolSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "poolSize"))) != null) {
            agentConfiguration.setPoolSize(Integer.parseInt(poolSize.getText()));
        }
        if ((maxPoolSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "maxPoolSize"))) != null) {
            agentConfiguration.setMaxPoolSize(Integer.parseInt(maxPoolSize.getText()));
        }
        if ((evictionTimePeriod = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "evictionTimePeriod"))) != null) {
            agentConfiguration.setEvictionTimePeriod(Integer.parseInt(evictionTimePeriod.getText()));
        }
        if ((secureEvictionTimePeriod = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "secureEvictionTimePeriod"))) != null) {
            agentConfiguration.setSecureEvictionTimePeriod(Integer.parseInt(secureEvictionTimePeriod.getText()));
        }
        if ((secureMaxIdleConnections = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "secureMaxIdleConnections"))) != null) {
            agentConfiguration.setEvictionTimePeriod(Integer.parseInt(secureMaxIdleConnections.getText()));
        }
        if ((secureMaxTransportPoolSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "secureMaxTransportPoolSize"))) != null) {
            agentConfiguration.setEvictionTimePeriod(Integer.parseInt(secureMaxTransportPoolSize.getText()));
        }
        if ((secureMinIdleTimeInPool = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "secureMinIdleTimeInPool"))) != null) {
            agentConfiguration.setEvictionTimePeriod(Integer.parseInt(secureMinIdleTimeInPool.getText()));
        }
        if ((asyncBuffer = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "asyncDataPublisherBufferedEventSize"))) != null) {
            agentConfiguration.setAsyncDataPublisherBufferedEventSize(Integer.parseInt(asyncBuffer.getText()));
        }
        if ((lbBuffer = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "lbDataPublisherBufferedEventSize"))) != null) {
            agentConfiguration.setLoadBalancingDataPublisherBufferedEventSize(Integer.parseInt(lbBuffer.getText()));
        }
        if ((reconnectionInterval = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "loadBalancingReconnectionInterval"))) != null) {
            agentConfiguration.setReconnectionInterval(Integer.parseInt(reconnectionInterval.getText()));
        }
    }

    private static void buildKeyStoreConfiguration(OMElement agentServerConfig, AgentConfiguration agentConfiguration) {
        OMElement trustStorePassword;
        OMElement trustStore = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "trustStore"));
        if (trustStore != null) {
            agentConfiguration.setTrustStore(trustStore.getText());
        }
        if ((trustStorePassword = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/databridge/agent/thrift", "trustStorePassword"))) != null) {
            agentConfiguration.setTrustStorePassword(trustStorePassword.getText());
        }
    }
}

