/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.message.databinding.ClassFinder;
import org.apache.axis2.jaxws.message.factory.ClassFinderFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.AnnotationDescImpl;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.FaultBeanDescImpl;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ArtifactProcessor {
    private static final Log log = LogFactory.getLog(ArtifactProcessor.class);
    private ServiceDescription serviceDesc;
    private Map<OperationDescription, String> requestWrapperMap = new HashMap<OperationDescription, String>();
    private Map<OperationDescription, String> responseWrapperMap = new HashMap<OperationDescription, String>();
    private Map<OperationDescription, Method> methodMap = new HashMap<OperationDescription, Method>();
    private Map<FaultDescription, FaultBeanDesc> faultBeanDescMap = new HashMap<FaultDescription, FaultBeanDesc>();
    static final String JAXWS_SUBPACKAGE = "jaxws";

    ArtifactProcessor(ServiceDescription serviceDesc) {
        this.serviceDesc = serviceDesc;
    }

    Map<OperationDescription, String> getRequestWrapperMap() {
        return this.requestWrapperMap;
    }

    Map<OperationDescription, String> getResponseWrapperMap() {
        return this.responseWrapperMap;
    }

    Map<FaultDescription, FaultBeanDesc> getFaultBeanDescMap() {
        return this.faultBeanDescMap;
    }

    Map<OperationDescription, Method> getMethodMap() {
        return this.methodMap;
    }

    void build() {
        for (EndpointDescription ed : this.serviceDesc.getEndpointDescriptions()) {
            if (ed.getEndpointInterfaceDescription() == null) continue;
            for (OperationDescription opDesc : ed.getEndpointInterfaceDescription().getOperations()) {
                Method method;
                Class cls;
                block11: {
                    String declaringClassName;
                    block10: {
                        String responseWrapperName;
                        String foundResponseWrapperName;
                        declaringClassName = opDesc.getJavaDeclaringClassName();
                        String packageName = ArtifactProcessor.getPackageName(declaringClassName);
                        String simpleName = ArtifactProcessor.getSimpleClassName(declaringClassName);
                        String methodName = opDesc.getJavaMethodName();
                        String requestWrapperName = opDesc.getRequestWrapperClassName();
                        String foundRequestWrapperName = ArtifactProcessor.getWrapperClass("@RequestWrapper", requestWrapperName, packageName, ArtifactProcessor.javaMethodToClassName(methodName), ed.getAxisService().getClassLoader(), this.serviceDesc);
                        if (foundRequestWrapperName != null) {
                            this.requestWrapperMap.put(opDesc, foundRequestWrapperName);
                        }
                        if ((foundResponseWrapperName = ArtifactProcessor.getWrapperClass("@ResponseWrapper", responseWrapperName = opDesc.getResponseWrapperClassName(), packageName, ArtifactProcessor.javaMethodToClassName(methodName) + "Response", ed.getAxisService().getClassLoader(), this.serviceDesc)) != null) {
                            this.responseWrapperMap.put(opDesc, foundResponseWrapperName);
                        }
                        for (FaultDescription faultDesc : opDesc.getFaultDescriptions()) {
                            FaultBeanDesc faultBeanDesc = this.create(ed, faultDesc, opDesc);
                            this.faultBeanDescMap.put(faultDesc, faultBeanDesc);
                        }
                        cls = null;
                        try {
                            cls = ArtifactProcessor.loadClass(declaringClassName, ArtifactProcessor.getContextClassLoader());
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block10;
                            log.debug((Object)("Class " + declaringClassName + " was not found by the Context ClassLoader.  " + "Will use the ClassLoader associated with the service.  The exception is: " + e));
                        }
                    }
                    if (cls == null) {
                        try {
                            cls = ArtifactProcessor.loadClass(declaringClassName, ed.getAxisService().getClassLoader());
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block11;
                            log.debug((Object)("Class " + declaringClassName + " was not found by the AxisService ClassLoader.  " + "Processing continues.  The exception is:" + e));
                        }
                    }
                }
                if (cls == null || (method = ArtifactProcessor.getMethod(opDesc.getJavaMethodName(), cls)) == null) continue;
                this.methodMap.put(opDesc, method);
            }
        }
    }

    private static String getWrapperClass(String type, String providedValue, String defaultPkg, String defaultClassName, ClassLoader altClassLoader, ServiceDescription serviceDesc) {
        String wrapperClass;
        block55: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getWrapperClass for " + type + " with value (" + providedValue + ")"));
            }
            wrapperClass = null;
            try {
                ClassLoader cl = ArtifactProcessor.getContextClassLoader();
                if (providedValue != null && providedValue.length() > 0) {
                    String origPackage;
                    Class cls = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Try finding the class with the name provided = " + providedValue));
                    }
                    if ((cls = ArtifactProcessor.loadClassOrNull(providedValue, cl)) != null) {
                        wrapperClass = providedValue;
                    } else {
                        cls = ArtifactProcessor.loadClassOrNull(providedValue, altClassLoader);
                        if (cls != null) {
                            wrapperClass = providedValue;
                        }
                    }
                    if (cls == null && (origPackage = ArtifactProcessor.getPackageName(providedValue)).length() > 0) {
                        String newPackage = origPackage + "." + JAXWS_SUBPACKAGE;
                        String clsName = ArtifactProcessor.getSimpleClassName(providedValue);
                        String newValue = newPackage + "." + clsName;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Did not find the name provided.  Now trying " + newValue));
                        }
                        if ((cls = ArtifactProcessor.loadClassOrNull(newValue, cl)) != null) {
                            wrapperClass = newValue;
                        } else {
                            cls = ArtifactProcessor.loadClassOrNull(newValue, altClassLoader);
                            if (cls != null) {
                                wrapperClass = newValue;
                            }
                        }
                        if (cls == null && (type.equals("@RequestWrapper") || type.equals("@ResponseWrapper") || type.equals("@WebFault") || type.equals("faultInfo"))) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Adding cache to classpath");
                            }
                            ClassFinderFactory cff = (ClassFinderFactory)FactoryRegistry.getFactory(ClassFinderFactory.class);
                            ClassFinder cf = cff.getClassFinder();
                            String cachePath = (String)serviceDesc.getAxisConfigContext().getProperty("wsCache");
                            if (cachePath != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"updating classpath with cache location");
                                }
                                cf.updateClassPath(cachePath, cl);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("trying to load class " + newValue + " from cache."));
                                }
                                if ((cls = ArtifactProcessor.loadClassOrNull(newValue, cl)) != null) {
                                    wrapperClass = newValue;
                                }
                            }
                        }
                    }
                } else {
                    Class cls1 = null;
                    Class cls2 = null;
                    boolean cls1IsJAXB = false;
                    boolean cls2IsJAXB = false;
                    String defaultValue = null;
                    defaultValue = defaultPkg.length() > 0 ? defaultPkg + "." + defaultClassName : defaultClassName;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No provided value.  Try the default class name =  " + defaultValue));
                    }
                    if ((cls1 = ArtifactProcessor.loadClassOrNull(defaultValue, cl)) == null) {
                        cls1 = ArtifactProcessor.loadClassOrNull(defaultValue, altClassLoader);
                    }
                    if (cls1 != null) {
                        cls1IsJAXB = ArtifactProcessor.isJAXB(cls1);
                    }
                    if (!(cls1 != null && cls1IsJAXB || defaultPkg.length() <= 0)) {
                        defaultValue = defaultPkg + "." + JAXWS_SUBPACKAGE + "." + defaultClassName;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Did not find the default name.  Try a different default class name =  " + defaultValue));
                        }
                        if ((cls2 = ArtifactProcessor.loadClassOrNull(defaultValue, cl)) == null) {
                            cls2 = ArtifactProcessor.loadClassOrNull(defaultValue, altClassLoader);
                        }
                        if (cls2 == null && (type.equals("@RequestWrapper") || type.equals("@ResponseWrapper") || type.equals("@WebFault") || type.equals("faultInfo"))) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Adding cache to classpath");
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Adding cache to classpath");
                            }
                            ClassFinderFactory cff = (ClassFinderFactory)FactoryRegistry.getFactory(ClassFinderFactory.class);
                            ClassFinder cf = cff.getClassFinder();
                            String cachePath = (String)serviceDesc.getAxisConfigContext().getProperty("wsCache");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("cachePath = " + cachePath));
                            }
                            if (cachePath != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"updating classpath with cache location");
                                }
                                cf.updateClassPath(cachePath, cl);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("trying to load class " + defaultValue + " from cache."));
                                }
                                cls2 = ArtifactProcessor.loadClassOrNull(defaultValue, cl);
                            }
                        }
                    }
                    if (cls2 != null) {
                        cls2IsJAXB = ArtifactProcessor.isJAXB(cls2);
                    }
                    if (cls1 == null && cls2 == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Could not find a wrapper class");
                        }
                        wrapperClass = null;
                    } else if (cls1 == null) {
                        wrapperClass = cls2.getCanonicalName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Choosing " + wrapperClass));
                        }
                    } else if (cls2 == null) {
                        wrapperClass = cls1.getCanonicalName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Choosing " + wrapperClass));
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("There are two classes that are present " + cls1 + " and " + cls2));
                        }
                        if (!cls1IsJAXB && !cls2IsJAXB) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Neither are JAXB enabled. Choosing " + cls2));
                            }
                            wrapperClass = cls2.getCanonicalName();
                        } else if (cls1IsJAXB && cls2IsJAXB) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Both are JAXB enabled. Choosing " + cls1));
                            }
                            wrapperClass = cls1.getCanonicalName();
                        } else if (cls1IsJAXB) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Choosing " + cls1 + " because it is JAXB enabled"));
                            }
                            wrapperClass = cls1.getCanonicalName();
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Choosing " + cls2 + " because it is JAXB enabled"));
                            }
                            wrapperClass = cls2.getCanonicalName();
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block55;
                log.debug((Object)"Unexpected error.  Processing continues. ", t);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("exit getWrapperClass with " + wrapperClass));
        }
        return wrapperClass;
    }

    private FaultBeanDesc create(EndpointDescription ed, FaultDescription faultDesc, OperationDescription opDesc) {
        String faultBeanNamespace;
        String faultBeanLocalName;
        String foundClassName;
        String declaringClassName = opDesc.getJavaDeclaringClassName();
        String type = "@WebFault";
        String faultBeanClassName = faultDesc.getFaultBean();
        if (faultBeanClassName == null || faultBeanClassName.length() == 0) {
            type = "faultInfo";
            faultBeanClassName = faultDesc.getFaultInfo();
        }
        if ((foundClassName = ArtifactProcessor.getWrapperClass(type, faultBeanClassName, ArtifactProcessor.getPackageName(declaringClassName), ArtifactProcessor.getSimpleClassName(faultDesc.getExceptionClassName()) + "Bean", ed.getAxisService().getClassLoader(), this.serviceDesc)) == null) {
            faultBeanClassName = this.missingArtifact(faultBeanClassName);
        }
        if (foundClassName != null) {
            faultBeanClassName = foundClassName;
        }
        if (((faultBeanLocalName = faultDesc.getName()) == null || faultBeanLocalName.length() == 0) && faultBeanClassName != null && faultBeanClassName.length() > 0) {
            try {
                Class faultBean;
                try {
                    faultBean = ArtifactProcessor.loadClass(faultBeanClassName, ArtifactProcessor.getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    faultBean = ArtifactProcessor.loadClass(faultBeanClassName, ed.getAxisService().getClassLoader());
                }
                AnnotationDesc aDesc = AnnotationDescImpl.create(faultBean);
                if (aDesc.hasXmlRootElement()) {
                    faultBeanLocalName = aDesc.getXmlRootElementName();
                }
            }
            catch (Throwable t) {
                throw ExceptionFactory.makeWebServiceException(t);
            }
        }
        if (faultBeanLocalName == null || faultBeanLocalName.length() == 0) {
            faultBeanLocalName = ArtifactProcessor.getSimpleClassName(faultDesc.getExceptionClassName()) + "Bean";
        }
        if (((faultBeanNamespace = faultDesc.getTargetNamespace()) == null || faultBeanNamespace.length() == 0) && faultBeanClassName != null && faultBeanClassName.length() > 0) {
            try {
                Class faultBean;
                try {
                    faultBean = ArtifactProcessor.loadClass(faultBeanClassName, ArtifactProcessor.getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    faultBean = ArtifactProcessor.loadClass(faultBeanClassName, ed.getAxisService().getClassLoader());
                }
                AnnotationDesc aDesc = AnnotationDescImpl.create(faultBean);
                if (aDesc.hasXmlRootElement()) {
                    faultBeanNamespace = aDesc.getXmlRootElementNamespace();
                }
            }
            catch (Throwable t) {
                throw ExceptionFactory.makeWebServiceException(t);
            }
        }
        if (faultBeanNamespace == null || faultBeanNamespace.length() == 0) {
            faultBeanNamespace = opDesc.getEndpointInterfaceDescription().getTargetNamespace();
        }
        return new FaultBeanDescImpl(faultBeanClassName, faultBeanLocalName, faultBeanNamespace);
    }

    private static String getPackageName(String className) {
        int index = className.lastIndexOf(".");
        if (index <= 0) {
            return "";
        }
        return className.substring(0, index);
    }

    private static String getSimpleClassName(String className) {
        int index = className.lastIndexOf(".");
        if (index <= 0) {
            return className;
        }
        return className.substring(index + 1);
    }

    private static String javaMethodToClassName(String methodName) {
        String className = null;
        if (methodName != null) {
            StringBuffer buildClassName = new StringBuffer(methodName);
            buildClassName.replace(0, 1, methodName.substring(0, 1).toUpperCase());
            className = buildClassName.toString();
        }
        return className;
    }

    private String missingArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("The following class was not found: " + artifactName + " Processing continues without this class."));
        }
        return null;
    }

    private static Class loadClassOrNull(String className, ClassLoader classLoader) {
        try {
            return ArtifactProcessor.loadClass(className, classLoader);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return ArtifactProcessor.forName(className, true, classLoader);
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    try {
                        if (cls == null) {
                            cls = Class.forName(className, initialize, classloader);
                        }
                        return cls;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        return cls;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static Method getMethod(final String methodName, final Class cls) {
        Method method = null;
        try {
            method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    Method[] methods = cls.getMethods();
                    if (methods != null) {
                        for (int i = 0; i < methods.length; ++i) {
                            if (!methods[i].getName().equals(methodName)) continue;
                            return methods[i];
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return method;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (RuntimeException)e.getException();
        }
        return cl;
    }

    private static boolean isJAXB(Class cls) {
        XmlRootElement root = (XmlRootElement)ArtifactProcessor.getAnnotation(cls, XmlRootElement.class);
        if (root != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("isJAXB returns true due to presence of @XmlRootElement on " + cls));
            }
            return true;
        }
        XmlType type = (XmlType)ArtifactProcessor.getAnnotation(cls, XmlType.class);
        if (type != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("isJAXB returns true due to presence of @XmlType on " + cls));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isJAXB returns false for" + cls));
        }
        return false;
    }

    private static Annotation getAnnotation(final AnnotatedElement element, final Class annotation) {
        Annotation anno;
        block2: {
            anno = null;
            try {
                anno = (Annotation)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return element.getAnnotation(annotation);
                    }
                });
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Problem occurred.  Continuing.  The problem is " + t));
            }
        }
        return anno;
    }
}

