/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.dispatch;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DispatchOperationHandler
extends AbstractHandler {
    private static final Log LOG = LogFactory.getLog(DispatchOperationHandler.class);

    private boolean isAnonymousOperation(AxisOperation op) {
        return ServiceClient.ANON_OUT_IN_OP.equals(op.getName()) || ServiceClient.ANON_OUT_ONLY_OP.equals(op.getName());
    }

    private QName getFirstBodyElement(SOAPEnvelope envelope) {
        OMElement firstElement;
        SOAPBody body = envelope.getBody();
        if (body != null && (firstElement = body.getFirstElement()) != null) {
            return firstElement.getQName();
        }
        return null;
    }

    private AxisOperation findRealOperationAction(MessageContext msgContext) {
        AxisOperation axisOperation = null;
        QName firstBodyElement = this.getFirstBodyElement(msgContext.getEnvelope());
        if (firstBodyElement != null) {
            AxisService service = msgContext.getAxisService();
            axisOperation = service.getOperationByMessageElementQName(firstBodyElement);
        }
        return axisOperation;
    }

    @Override
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        AxisOperation op = msgContext.getAxisOperation();
        if (!msgContext.isServerSide() && op != null && this.isAnonymousOperation(op) && (op = this.findRealOperationAction(msgContext)) != null) {
            msgContext.setAxisOperation(op);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Anonymous operation detected. Replaced with real operation: " + op));
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

