/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils.reader;

import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBNamespaceContext;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReader;

public class ADBDataHandlerStreamReader
implements ADBXMLStreamReader {
    private static final int START_ELEMENT_STATE = 0;
    private static final int TEXT_STATE = 1;
    private static final int END_ELEMENT_STATE = 2;
    private ADBNamespaceContext namespaceContext = new ADBNamespaceContext();
    private QName name;
    private DataHandler value;
    private int state = 0;
    private boolean nsDeclared = false;
    private String convertedText = null;

    public ADBDataHandlerStreamReader(QName name, DataHandler value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public Object getProperty(String propKey) throws IllegalArgumentException {
        if ("IsDatahandlersAwareParsing".equals(propKey)) {
            return Boolean.TRUE;
        }
        if (this.state == 1) {
            if ("Axiom.IsBinary".equals(propKey)) {
                return Boolean.TRUE;
            }
            if ("Axiom.DataHandler".equals(propKey)) {
                return this.value;
            }
        }
        return null;
    }

    @Override
    public int next() throws XMLStreamException {
        switch (this.state) {
            case 0: {
                this.state = 1;
                return 4;
            }
            case 2: {
                throw new XMLStreamException("end already reached!");
            }
            case 1: {
                this.state = 2;
                return 2;
            }
        }
        throw new XMLStreamException("unknown event type!");
    }

    @Override
    public void require(int i, String string, String string1) throws XMLStreamException {
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.state == 1) {
            this.state = 2;
            if (this.convertedText == null) {
                this.convertedText = ConverterUtil.getStringFromDatahandler(this.value);
            }
            return this.convertedText;
        }
        throw new XMLStreamException();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return 0;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.state != 2;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaceContext.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.state == 0;
    }

    @Override
    public boolean isEndElement() {
        return this.state == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.state == 1;
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String string, String string1) {
        return null;
    }

    @Override
    public int getAttributeCount() {
        return 0;
    }

    @Override
    public QName getAttributeName(int i) {
        return null;
    }

    @Override
    public String getAttributeNamespace(int i) {
        return null;
    }

    @Override
    public String getAttributeLocalName(int i) {
        return null;
    }

    @Override
    public String getAttributePrefix(int i) {
        return null;
    }

    @Override
    public String getAttributeType(int i) {
        return null;
    }

    @Override
    public String getAttributeValue(int i) {
        return null;
    }

    @Override
    public boolean isAttributeSpecified(int i) {
        return false;
    }

    @Override
    public int getNamespaceCount() {
        return this.nsDeclared ? 1 : 0;
    }

    @Override
    public String getNamespacePrefix(int i) {
        return this.nsDeclared && i == 0 ? this.name.getPrefix() : null;
    }

    @Override
    public String getNamespaceURI(int i) {
        return this.nsDeclared && i == 0 ? this.name.getNamespaceURI() : null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public int getEventType() {
        switch (this.state) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        if (this.state == 1) {
            if (this.convertedText == null) {
                this.convertedText = ConverterUtil.getStringFromDatahandler(this.value);
            }
            return this.convertedText;
        }
        throw new IllegalStateException();
    }

    @Override
    public char[] getTextCharacters() {
        if (this.state == 1) {
            if (this.convertedText == null) {
                this.convertedText = ConverterUtil.getStringFromDatahandler(this.value);
            }
            return this.convertedText.toCharArray();
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTextStart() {
        if (this.state == 1) {
            return 0;
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextLength() {
        if (this.state == 1) {
            if (this.convertedText == null) {
                this.convertedText = ConverterUtil.getStringFromDatahandler(this.value);
            }
            return this.convertedText.length();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean hasText() {
        return this.state == 1;
    }

    @Override
    public Location getLocation() {
        return new Location(){

            @Override
            public int getLineNumber() {
                return 0;
            }

            @Override
            public int getColumnNumber() {
                return 0;
            }

            @Override
            public int getCharacterOffset() {
                return 0;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public QName getName() {
        if (this.state != 1) {
            return this.name;
        }
        return null;
    }

    @Override
    public String getLocalName() {
        if (this.state != 1) {
            return this.name.getLocalPart();
        }
        return null;
    }

    @Override
    public boolean hasName() {
        return this.state != 1;
    }

    @Override
    public String getNamespaceURI() {
        if (this.state != 1) {
            return this.name.getNamespaceURI();
        }
        return null;
    }

    @Override
    public String getPrefix() {
        if (this.state != 1) {
            return this.name.getPrefix();
        }
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        return null;
    }

    @Override
    public String getPIData() {
        return null;
    }

    @Override
    public boolean isDone() {
        return this.state == 2;
    }

    @Override
    public void addNamespaceContext(NamespaceContext nsContext) {
        this.namespaceContext.setParentNsContext(nsContext);
    }

    @Override
    public void init() {
        this.addToNsMap(this.name.getPrefix(), this.name.getNamespaceURI());
    }

    private void addToNsMap(String prefix, String uri) {
        if (!uri.equals(this.namespaceContext.getNamespaceURI(prefix))) {
            this.namespaceContext.pushNamespace(prefix, uri);
            this.nsDeclared = true;
        }
    }
}

