/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.clustering.state.StateClusteringCommandFactory;
import org.apache.axis2.clustering.state.StateManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;

public class GetStateCommand
extends ControlCommand {
    private StateClusteringCommand[] commands;

    @Override
    public void execute(ConfigurationContext configCtx) throws ClusteringFault {
        ClusteringAgent clusteringAgent = configCtx.getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent == null) {
            return;
        }
        StateManager stateManager = clusteringAgent.getStateManager();
        if (stateManager != null) {
            String[] sgCtxIDs;
            Map excludedPropPatterns = stateManager.getReplicationExcludePatterns();
            ArrayList<StateClusteringCommand> cmdList = new ArrayList<StateClusteringCommand>();
            for (String sgCtxID : sgCtxIDs = configCtx.getServiceGroupContextIDs()) {
                ServiceGroupContext sgCtx = configCtx.getServiceGroupContext(sgCtxID);
                StateClusteringCommand updateServiceGroupCtxCmd = StateClusteringCommandFactory.getUpdateCommand(sgCtx, excludedPropPatterns, true);
                if (updateServiceGroupCtxCmd != null) {
                    cmdList.add(updateServiceGroupCtxCmd);
                }
                if (sgCtx.getServiceContexts() == null) continue;
                Iterator<ServiceContext> iter2 = sgCtx.getServiceContexts();
                while (iter2.hasNext()) {
                    ServiceContext serviceCtx = iter2.next();
                    StateClusteringCommand updateServiceCtxCmd = StateClusteringCommandFactory.getUpdateCommand(serviceCtx, excludedPropPatterns, true);
                    if (updateServiceCtxCmd == null) continue;
                    cmdList.add(updateServiceCtxCmd);
                }
            }
            StateClusteringCommand updateCmd = StateClusteringCommandFactory.getUpdateCommand(configCtx, excludedPropPatterns, true);
            if (updateCmd != null) {
                cmdList.add(updateCmd);
            }
            if (!cmdList.isEmpty()) {
                this.commands = cmdList.toArray(new StateClusteringCommand[cmdList.size()]);
            }
        }
    }

    public StateClusteringCommand[] getCommands() {
        return this.commands;
    }

    public String toString() {
        return "GetStateCommand";
    }
}

