/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.tenant;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageListener;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class TenantEventReceiver {
    private static final Log log = LogFactory.getLog(TenantEventReceiver.class);
    private TenantEventMessageDelegator messageDelegator;
    private TenantEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private ExecutorService executorService;

    public TenantEventReceiver() {
        TenantEventMessageQueue messageQueue = new TenantEventMessageQueue();
        this.messageDelegator = new TenantEventMessageDelegator(messageQueue);
        this.messageListener = new TenantEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.TENANT_TOPIC.getTopicName(), this.messageListener);
                this.executorService.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Tenant event message receiver thread started");
                }
                this.executorService.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Tenant event message delegator thread started");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Tenant receiver failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }
}

