/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.domain.mapping;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.domain.mapping.DomainMappingMessageProcessorChain;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventMessageQueue;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingManager;

class DomainMappingEventMessageDelegator
implements Runnable {
    private static final Log log = LogFactory.getLog(DomainMappingEventMessageDelegator.class);
    private MessageProcessorChain processorChain;
    private DomainMappingEventMessageQueue messageQueue;
    private boolean terminated;

    public DomainMappingEventMessageDelegator(DomainMappingEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        this.processorChain = new DomainMappingMessageProcessorChain();
    }

    public void addEventListener(EventListener eventListener) {
        this.processorChain.addEventListener(eventListener);
    }

    @Override
    public void run() {
        block9: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Domain mapping event message delegator started");
                }
                while (!this.terminated) {
                    try {
                        Message message = (Message)this.messageQueue.take();
                        String type = message.getEventClassName();
                        String json = message.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Domain mapping event message received from queue: [event-class-name] %s [message-queue] %s", type, this.messageQueue.getClass()));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delegating domain mapping event message: %s", type));
                        }
                        this.processorChain.process(type, json, DomainMappingManager.getInstance());
                    }
                    catch (InterruptedException e) {
                        log.info((Object)"Shutting down domain mapping event message delegator...");
                        this.terminate();
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve domain mapping event message", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Domain mapping event message delegator failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

