/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ApplicationClustersCreatedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyApplicationFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationClustersCreatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationClustersCreatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ApplicationClustersCreatedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ApplicationClustersCreatedEvent event = (ApplicationClustersCreatedEvent)MessagingUtil.jsonToObject(message, ApplicationClustersCreatedEvent.class);
            return this.doProcess(event, topology);
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcess(ApplicationClustersCreatedEvent event, Topology topology) {
        List<Cluster> clusters = event.getClusterList();
        for (Cluster cluster : clusters) {
            String applicationId = cluster.getAppId();
            String serviceName = cluster.getServiceName();
            String clusterId = cluster.getClusterId();
            TopologyUpdater.acquireWriteLockForService(serviceName);
            try {
                if (TopologyApplicationFilter.apply(applicationId) || TopologyServiceFilter.apply(serviceName) || TopologyClusterFilter.apply(clusterId)) continue;
                Service service = topology.getService(serviceName);
                if (service == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Service does not exist: [service] %s", serviceName));
                    }
                    boolean bl = false;
                    return bl;
                }
                if (service.clusterExists(clusterId)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Cluster already exists in service: [service] %s [cluster] %s", serviceName, clusterId));
                    continue;
                }
                service.addCluster(cluster);
                topology.addToCluterMap(cluster);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)String.format("Cluster created: %s", cluster.toString()));
            }
            finally {
                TopologyUpdater.releaseWriteLockForService(serviceName);
            }
        }
        this.notifyEventListeners(event);
        return true;
    }
}

