/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.event.application.ApplicationCreatedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.application.updater.ApplicationsUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationCreatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationCreatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Applications applications = (Applications)object;
        if (ApplicationCreatedEvent.class.getName().equals(type)) {
            if (!applications.isInitialized()) {
                return false;
            }
            ApplicationCreatedEvent event = (ApplicationCreatedEvent)MessagingUtil.jsonToObject(message, ApplicationCreatedEvent.class);
            if (event == null) {
                log.error((Object)"Unable to convert the JSON message to ApplicationCreatedEvent");
                return false;
            }
            ApplicationsUpdater.acquireWriteLockForApplications();
            try {
                boolean bl = this.doProcess(event, applications);
                return bl;
            }
            finally {
                ApplicationsUpdater.releaseWriteLockForApplications();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, applications);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ApplicationCreatedEvent event, Applications applications) {
        if (event.getApplication() == null) {
            String errorMsg = "Application object of application created event is invalid";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (event.getApplication().getUniqueIdentifier() == null || event.getApplication().getUniqueIdentifier().isEmpty()) {
            String errorMsg = "App id of application created event is invalid: [ " + event.getApplication().getUniqueIdentifier() + " ]";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (applications.applicationExists(event.getApplication().getUniqueIdentifier())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Application with id [ " + event.getApplication().getUniqueIdentifier() + " ] already exists"));
            }
        } else {
            applications.addApplication(event.getApplication());
            if (log.isInfoEnabled()) {
                log.info((Object)("Application with id [ " + event.getApplication().getUniqueIdentifier() + " ] created"));
            }
        }
        this.notifyEventListeners(event);
        return true;
    }
}

