/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.instance;

import java.io.Serializable;
import java.util.Properties;
import org.apache.stratos.messaging.domain.topology.lifecycle.LifeCycleState;
import org.apache.stratos.messaging.domain.topology.lifecycle.LifeCycleStateManager;

public abstract class Instance<T extends LifeCycleState>
implements Serializable {
    protected String alias;
    protected String instanceId;
    protected Properties instanceProperties;
    protected LifeCycleStateManager<T> lifeCycleStateManager;
    private String parentId;
    private String networkPartitionId;
    protected String partitionId;

    public Instance(String alias, String instanceId) {
        this.alias = alias;
        this.instanceId = instanceId;
        this.instanceProperties = new Properties();
    }

    public void addProperty(String name, String value) {
        this.instanceProperties.put(name, value);
    }

    public String getProperty(String name) {
        return this.instanceProperties.getProperty(name);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Instance)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Instance that = (Instance)other;
        return this.alias.equals(that.alias) && this.instanceId.equals(that.instanceId);
    }

    public int hashCode() {
        return this.alias.hashCode() + this.instanceId.hashCode();
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getNetworkPartitionId() {
        return this.networkPartitionId;
    }

    public void setNetworkPartitionId(String networkPartitionId) {
        this.networkPartitionId = networkPartitionId;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }
}

