/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring;

import org.compass.core.Compass;
import org.compass.core.CompassSession;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.support.session.CompassSessionTransactionalProxy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LocalCompassSessionBean
implements FactoryBean,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Compass compass;
    private CompassSession compassSession;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.compass == null) {
            String[] compassesNames = this.applicationContext.getBeanNamesForType(Compass.class);
            if (compassesNames.length == 1) {
                this.compass = (Compass)this.applicationContext.getBean(compassesNames[0]);
            } else {
                throw new IllegalArgumentException("compass instance not set and application context has more than one compass instance");
            }
        }
        this.compassSession = CompassSessionTransactionalProxy.newProxy(this.compass);
    }

    public void setCompass(Compass compass) {
        this.compass = compass;
    }

    public Object getObject() throws Exception {
        return this.compassSession;
    }

    public Class getObjectType() {
        return InternalCompassSession.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

