/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.jndi;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassSettings;

public abstract class NamingHelper {
    private static final Log log = LogFactory.getLog(NamingHelper.class);

    public static InitialContext getInitialContext(CompassSettings settings) throws NamingException {
        Properties hash = NamingHelper.getJndiProperties(settings);
        try {
            return ((Hashtable)hash).size() == 0 ? new InitialContext() : new InitialContext(hash);
        }
        catch (NamingException e) {
            log.error((Object)("Could not obtain initial context with settings [" + hash + "]"), (Throwable)e);
            throw e;
        }
    }

    public static void bind(Context ctx, String name, Object val) throws NamingException {
        try {
            ctx.rebind(name, val);
        }
        catch (Exception e) {
            Name n = ctx.getNameParser("").parse(name);
            while (n.size() > 1) {
                String ctxName = n.get(0);
                Context subctx = null;
                try {
                    subctx = (Context)ctx.lookup(ctxName);
                }
                catch (NameNotFoundException nfe) {
                    // empty catch block
                }
                ctx = subctx != null ? subctx : ctx.createSubcontext(ctxName);
                n = n.getSuffix(1);
            }
            ctx.rebind(n, val);
        }
    }

    public static Properties getJndiProperties(CompassSettings settings) {
        HashSet<String> specialProps = new HashSet<String>();
        specialProps.add("compass.jndi.class");
        specialProps.add("compass.jndi.url");
        specialProps.add("compass.jndi.enable");
        Iterator iter = settings.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (prop.indexOf("compass.jndi") <= -1 || specialProps.contains(prop)) continue;
            result.setProperty(prop.substring("compass.jndi".length() + 1), settings.getSetting(prop));
        }
        String jndiClass = settings.getSetting("compass.jndi.class");
        String jndiURL = settings.getSetting("compass.jndi.url");
        if (jndiClass != null) {
            result.put("java.naming.factory.initial", jndiClass);
        }
        if (jndiURL != null) {
            result.put("java.naming.provider.url", jndiURL);
        }
        return result;
    }
}

