/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.TopicSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageListener;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageQueue;

public class TopologyEventReceiver
implements Runnable {
    private static final Log log = LogFactory.getLog(TopologyEventReceiver.class);
    private TopologyEventMessageDelegator messageDelegator;
    private TopologyEventMessageListener messageListener;
    private TopicSubscriber topicSubscriber;
    private boolean terminated;

    public TopologyEventReceiver() {
        TopologyEventMessageQueue messageQueue = new TopologyEventMessageQueue();
        this.messageDelegator = new TopologyEventMessageDelegator(messageQueue);
        this.messageListener = new TopologyEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void run() {
        block7: {
            try {
                this.topicSubscriber = new TopicSubscriber("topology");
                this.topicSubscriber.setMessageListener(this.messageListener);
                Thread subscriberThread = new Thread(this.topicSubscriber);
                subscriberThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Topology event message receiver thread started");
                }
                Thread receiverThread = new Thread(this.messageDelegator);
                receiverThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Topology event message delegator thread started");
                }
                while (!this.terminated) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Topology receiver failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.topicSubscriber.terminate();
        this.messageDelegator.terminate();
        this.terminated = true;
    }
}

