/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.TopicSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageListener;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageQueue;

public class TenantEventReceiver
implements Runnable {
    private static final Log log = LogFactory.getLog(TenantEventReceiver.class);
    private TenantEventMessageDelegator messageDelegator;
    private TenantEventMessageListener messageListener;
    private TopicSubscriber topicSubscriber;
    private boolean terminated;

    public TenantEventReceiver() {
        TenantEventMessageQueue messageQueue = new TenantEventMessageQueue();
        this.messageDelegator = new TenantEventMessageDelegator(messageQueue);
        this.messageListener = new TenantEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void run() {
        block7: {
            try {
                this.topicSubscriber = new TopicSubscriber("tenant");
                this.topicSubscriber.setMessageListener(this.messageListener);
                Thread subscriberThread = new Thread(this.topicSubscriber);
                subscriberThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Tenant event message receiver thread started");
                }
                Thread receiverThread = new Thread(this.messageDelegator);
                receiverThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Tenant event message delegator thread started");
                }
                while (!this.terminated) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Tenant receiver failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.topicSubscriber.terminate();
        this.messageDelegator.terminate();
        this.terminated = true;
    }
}

