/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.tenant.Tenant;
import org.apache.stratos.messaging.event.tenant.TenantUnSubscribedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.tenant.TenantManager;
import org.apache.stratos.messaging.util.Util;

public class TenantUnSubscribedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(TenantUnSubscribedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        if (TenantUnSubscribedEvent.class.getName().equals(type)) {
            if (!TenantManager.getInstance().isInitialized()) {
                return false;
            }
            TenantUnSubscribedEvent event = (TenantUnSubscribedEvent)Util.jsonToObject(message, TenantUnSubscribedEvent.class);
            try {
                TenantManager.acquireWriteLock();
                Tenant tenant = TenantManager.getInstance().getTenant(event.getTenantId());
                if (tenant == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Tenant not found: [tenant-id] %d", event.getTenantId()));
                    }
                    boolean bl = false;
                    return bl;
                }
                tenant.removeServiceSubscription(event.getServiceName());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Tenant un-subscribed from service: [tenant-id] %d [tenant-domain] %s [service] %s", tenant.getTenantId(), tenant.getTenantDomain(), event.getServiceName()));
                }
                this.notifyEventListeners(event);
                boolean bl = true;
                return bl;
            }
            finally {
                TenantManager.releaseWriteLock();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process tenant message using available message processors: [type] %s [body] %s", type, message));
    }
}

