/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wso2.andes.common.Closeable;
import org.wso2.andes.thread.Threading;
import org.wso2.andes.transport.Receiver;
import org.wso2.andes.transport.TransportException;
import org.wso2.andes.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoReceiver
implements Runnable,
Closeable {
    private static final Logger log = Logger.get(IoReceiver.class);
    private final Receiver<ByteBuffer> receiver;
    private final int bufferSize;
    private final Socket socket;
    private final long timeout;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Thread receiverThread;
    private static final boolean shutdownBroken;

    public IoReceiver(Socket socket, Receiver<ByteBuffer> receiver, int bufferSize, long timeout) {
        this.receiver = receiver;
        this.bufferSize = bufferSize;
        this.socket = socket;
        this.timeout = timeout;
        try {
            this.receiverThread = Threading.getThreadFactory().createThread(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating IOReceiver thread", e);
        }
        this.receiverThread.setDaemon(true);
        this.receiverThread.setName(String.format("IoReceiver - %s", socket.getRemoteSocketAddress()));
    }

    public void initiate() {
        this.receiverThread.start();
    }

    @Override
    public void close() {
        this.close(false);
    }

    void close(boolean block) {
        if (!this.closed.getAndSet(true)) {
            try {
                if (shutdownBroken) {
                    this.socket.close();
                } else {
                    this.socket.shutdownInput();
                }
                if (block && Thread.currentThread() != this.receiverThread) {
                    this.receiverThread.join(this.timeout);
                    if (this.receiverThread.isAlive()) {
                        throw new TransportException("join timed out");
                    }
                }
            }
            catch (InterruptedException e) {
                throw new TransportException(e);
            }
            catch (IOException e) {
                throw new TransportException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int threshold = this.bufferSize / 2;
        byte[] buffer = new byte[this.bufferSize];
        try {
            InputStream in = this.socket.getInputStream();
            int read = 0;
            int offset = 0;
            while ((read = in.read(buffer, offset, this.bufferSize - offset)) != -1) {
                if (read <= 0) continue;
                ByteBuffer b = ByteBuffer.wrap(buffer, offset, read);
                this.receiver.received(b);
                if ((offset += read) <= threshold) continue;
                offset = 0;
                buffer = new byte[this.bufferSize];
            }
        }
        catch (Throwable t) {
            if (!(shutdownBroken && t instanceof SocketException && t.getMessage().equalsIgnoreCase("socket closed") && this.closed.get())) {
                this.receiver.exception(t);
            }
        }
        finally {
            this.receiver.closed();
            try {
                this.socket.close();
            }
            catch (Exception e) {
                log.warn(e, "Error closing socket", new Object[0]);
            }
        }
    }

    static {
        String osName = System.getProperty("os.name");
        shutdownBroken = osName == null ? false : osName.matches("(?i).*windows.*");
    }
}

