/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.messaging.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.wso2.andes.messaging.util.Lexer;
import org.wso2.andes.messaging.util.Token;

public class Lexicon {
    private List<Token.Type> types = new ArrayList<Token.Type>();
    private Token.Type eof = null;

    public Token.Type define(String name, String pattern) {
        Token.Type t = new Token.Type(name, pattern);
        this.types.add(t);
        return t;
    }

    public Token.Type eof(String name) {
        Token.Type t;
        this.eof = t = new Token.Type(name, null);
        return t;
    }

    public Lexer compile() {
        StringBuilder joined = new StringBuilder();
        for (Token.Type t : this.types) {
            if (joined.length() > 0) {
                joined.append('|');
            }
            joined.append('(').append(t.getPattern()).append(')');
        }
        Pattern rexp = Pattern.compile(joined.toString());
        return new Lexer(new ArrayList<Token.Type>(this.types), this.eof, rexp);
    }

    public static final void main(String[] args) {
        StringBuilder input = new StringBuilder();
        for (String a : args) {
            if (input.length() > 0) {
                input.append(" ");
            }
            input.append(a);
        }
        Lexicon lxi = new Lexicon();
        lxi.define("FOR", "for");
        lxi.define("IF", "if");
        lxi.define("LPAREN", "\\(");
        lxi.define("RPAREN", "\\)");
        lxi.define("ID", "[\\S]+");
        lxi.define("WSPACE", "[\\s]+");
        lxi.eof("EOF");
        Lexer lx = lxi.compile();
        for (Token t : lx.lex(input.toString())) {
            System.out.println(t);
        }
    }
}

