/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.extension.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.load.balancer.common.statistics.LoadBalancerStatisticsReader;
import org.apache.stratos.load.balancer.common.statistics.notifier.LoadBalancerStatisticsNotifier;
import org.apache.stratos.load.balancer.extension.api.LoadBalancer;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.topology.ClusterRemovedEventListener;
import org.apache.stratos.messaging.listener.topology.CompleteTopologyEventListener;
import org.apache.stratos.messaging.listener.topology.MemberActivatedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberSuspendedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberTerminatedEventListener;
import org.apache.stratos.messaging.listener.topology.ServiceRemovedEventListener;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventReceiver;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;

public class LoadBalancerExtension
implements Runnable {
    private static final Log log = LogFactory.getLog(LoadBalancerExtension.class);
    private LoadBalancer loadBalancer;
    private LoadBalancerStatisticsReader statsReader;
    private boolean loadBalancerStarted;
    private TopologyEventReceiver topologyEventReceiver;
    private LoadBalancerStatisticsNotifier statisticsNotifier;
    private boolean terminated;

    public LoadBalancerExtension(LoadBalancer loadBalancer, LoadBalancerStatisticsReader statsReader) {
        this.loadBalancer = loadBalancer;
        this.statsReader = statsReader;
    }

    @Override
    public void run() {
        block7: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Load balancer extension started");
                }
                this.topologyEventReceiver = new TopologyEventReceiver();
                this.addEventListeners();
                Thread topologyReceiverThread = new Thread((Runnable)this.topologyEventReceiver);
                topologyReceiverThread.start();
                if (this.statsReader != null) {
                    this.statisticsNotifier = new LoadBalancerStatisticsNotifier(this.statsReader);
                    Thread statsNotifierThread = new Thread((Runnable)this.statisticsNotifier);
                    statsNotifierThread.start();
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"Load balancer statistics reader not found");
                }
                while (!this.terminated) {
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Could not start load balancer extension", (Throwable)e);
            }
        }
    }

    private void addEventListeners() {
        this.topologyEventReceiver.addEventListener((EventListener)new CompleteTopologyEventListener(){

            protected void onEvent(Event event) {
                try {
                    LoadBalancerExtension.this.loadBalancer.configure(TopologyManager.getTopology());
                    LoadBalancerExtension.this.loadBalancer.start();
                    LoadBalancerExtension.this.loadBalancerStarted = true;
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Could not start load balancer", (Throwable)e);
                    }
                    LoadBalancerExtension.this.terminate();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberActivatedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberSuspendedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberTerminatedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ClusterRemovedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ServiceRemovedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
    }

    private void reloadConfiguration() {
        block3: {
            try {
                if (this.loadBalancerStarted) {
                    this.loadBalancer.reload(TopologyManager.getTopology());
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Could not reload load balancer configuration", (Throwable)e);
            }
        }
    }

    public void terminate() {
        if (this.topologyEventReceiver != null) {
            this.topologyEventReceiver.terminate();
        }
        if (this.statisticsNotifier != null) {
            this.statisticsNotifier.terminate();
        }
        this.terminated = true;
    }
}

