/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.synchronization.RegistrySynchronizer;
import org.wso2.carbon.registry.synchronization.SynchronizationException;

public class RegistryBasedRepository {
    private static Log log = LogFactory.getLog(RegistryBasedRepository.class);
    private UserRegistry configSystemRegistry;
    private String registryPath;
    private String fileSystemRepo;

    public RegistryBasedRepository(UserRegistry configSystemRegistry, String registryPath, String fileSystemRepo) {
        this.configSystemRegistry = configSystemRegistry;
        this.registryPath = registryPath;
        this.fileSystemRepo = fileSystemRepo;
        try {
            if (!configSystemRegistry.resourceExists(registryPath)) {
                configSystemRegistry.put(registryPath, (Resource)configSystemRegistry.newCollection());
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Could not create registry path " + registryPath), (Throwable)e);
        }
    }

    public void updateFileSystemFromRegistry() {
        try {
            if (RegistrySynchronizer.isCheckedOut((String)this.fileSystemRepo)) {
                RegistrySynchronizer.update((UserRegistry)this.configSystemRegistry, (String)this.fileSystemRepo, (boolean)true);
                try {
                    RegistrySynchronizer.checkIn((UserRegistry)this.configSystemRegistry, (String)this.fileSystemRepo, (boolean)false);
                }
                catch (SynchronizationException e) {
                    log.error((Object)"Error on Registry repo synchronization", (Throwable)e);
                }
            } else {
                RegistrySynchronizer.checkOut((UserRegistry)this.configSystemRegistry, (String)this.fileSystemRepo, (String)this.registryPath);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error dumping repository from registry.", (Throwable)e);
        }
    }

    public void storeArtifactToRegistry(InputStream artifactStream, String resourcePath) throws Exception {
        Resource artifactResource = this.configSystemRegistry.newResource();
        artifactResource.setContentStream(artifactStream);
        this.configSystemRegistry.put(resourcePath, artifactResource);
    }

    public void deleteArtifactFromRegistry(String fileSystemPath) {
    }
}

