/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.haproxy.extension;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.util.CommandUtils;
import org.apache.stratos.haproxy.extension.HAProxyConfigWriter;
import org.apache.stratos.haproxy.extension.HAProxyContext;
import org.apache.stratos.load.balancer.extension.api.LoadBalancer;
import org.apache.stratos.load.balancer.extension.api.exception.LoadBalancerExtensionException;
import org.apache.stratos.messaging.domain.topology.Topology;

public class HAProxy
implements LoadBalancer {
    private static final Log log = LogFactory.getLog(HAProxy.class);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private String executableFilePath = HAProxyContext.getInstance().getExecutableFilePath();
    private String processIdFilePath;
    private String templatePath = HAProxyContext.getInstance().getTemplatePath();
    private String templateName = HAProxyContext.getInstance().getTemplateName();
    private String confFilePath = HAProxyContext.getInstance().getConfFilePath();
    private String statsSocketFilePath;

    public HAProxy() {
        this.processIdFilePath = this.confFilePath.replace(".cfg", ".pid");
        this.statsSocketFilePath = HAProxyContext.getInstance().getStatsSocketFilePath();
    }

    private void reloadConfiguration() throws LoadBalancerExtensionException {
        try {
            String line;
            if (log.isInfoEnabled()) {
                log.info((Object)"Reloading configuration...");
            }
            String pid = "";
            BufferedReader reader = new BufferedReader(new FileReader(this.processIdFilePath));
            while ((line = reader.readLine()) != null) {
                pid = pid + line + " ";
            }
            String command = this.executableFilePath + " -f " + this.confFilePath + " -p " + this.processIdFilePath + " -sf " + pid;
            CommandUtils.executeCommand((String)command);
            if (log.isInfoEnabled()) {
                log.info((Object)"Configuration done");
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Reconfiguration failed");
            }
            throw new LoadBalancerExtensionException((Throwable)e);
        }
    }

    public void reload(Topology topology) throws LoadBalancerExtensionException {
        this.configure(topology);
        this.reloadConfiguration();
    }

    public void configure(Topology topology) throws LoadBalancerExtensionException {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)"Configuring haproxy instance...");
            }
            HAProxyConfigWriter writer = new HAProxyConfigWriter(this.templatePath, this.templateName, this.confFilePath, this.statsSocketFilePath);
            writer.write(topology);
            if (log.isInfoEnabled()) {
                log.info((Object)"Configuration done");
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not configure haproxy");
            }
            throw new LoadBalancerExtensionException((Throwable)e);
        }
    }

    public void start() throws LoadBalancerExtensionException {
        File conf = new File(this.confFilePath);
        if (!conf.exists()) {
            throw new LoadBalancerExtensionException("Could not find haproxy configuration file");
        }
        try {
            String command = this.executableFilePath + " -f " + this.confFilePath + " -p " + this.processIdFilePath;
            CommandUtils.executeCommand((String)command);
            if (log.isInfoEnabled()) {
                log.info((Object)"haproxy started");
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not start haproxy");
            }
            throw new LoadBalancerExtensionException((Throwable)e);
        }
    }

    public void stop() throws LoadBalancerExtensionException {
        try {
            String pid_;
            Vector<String> pids = new Vector<String>();
            BufferedReader reader = new BufferedReader(new FileReader(this.processIdFilePath));
            while ((pid_ = reader.readLine()) != null) {
                pids.add(pid_);
            }
            for (String pid : pids) {
                String command = "kill -s 9 " + pid;
                CommandUtils.executeCommand((String)command);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)String.format("haproxy stopped [pid] %s", pid));
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not stop haproxy");
            }
            throw new LoadBalancerExtensionException((Throwable)e);
        }
    }
}

