/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.transport;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.git.transport.GitSshdSession;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

public class GitSshdSessionFactory
extends SshSessionFactory
implements ClientSessionHolder {
    public static final GitSshdSessionFactory INSTANCE = new GitSshdSessionFactory();
    private final SshClient client;
    private final ClientSession session;

    public GitSshdSessionFactory() {
        this(null, null);
    }

    public GitSshdSessionFactory(SshClient client) {
        this(Objects.requireNonNull(client, "No client instance provided"), null);
    }

    public GitSshdSessionFactory(ClientSession session) {
        this(null, session);
    }

    protected GitSshdSessionFactory(SshClient client, ClientSession session) {
        this.client = client;
        this.session = session;
    }

    public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        try {
            return new GitSshdSession(uri, credentialsProvider, fs, tms){

                @Override
                protected SshClient createClient() {
                    SshClient thisClient = GitSshdSessionFactory.this.getClient();
                    if (thisClient != null) {
                        return thisClient;
                    }
                    return super.createClient();
                }

                @Override
                protected ClientSession createClientSession(SshClient clientInstance, String host, String username, int port, String ... passwords) throws IOException, InterruptedException {
                    ClientSession thisSession = GitSshdSessionFactory.this.getClientSession();
                    if (thisSession != null) {
                        return thisSession;
                    }
                    return super.createClientSession(clientInstance, host, username, port, passwords);
                }

                @Override
                protected void disconnectSession(ClientSession sessionInstance) {
                    ClientSession thisSession = GitSshdSessionFactory.this.getClientSession();
                    if (GenericUtils.isSameReference((Object)thisSession, (Object)sessionInstance)) {
                        return;
                    }
                    super.disconnectSession(sessionInstance);
                }

                @Override
                protected void disconnectClient(SshClient clientInstance) {
                    SshClient thisClient = GitSshdSessionFactory.this.getClient();
                    if (GenericUtils.isSameReference((Object)thisClient, (Object)clientInstance)) {
                        return;
                    }
                    super.disconnectClient(clientInstance);
                }
            };
        }
        catch (Exception e) {
            throw new TransportException("Unable to connect", (Throwable)e);
        }
    }

    protected SshClient getClient() {
        return this.client;
    }

    public ClientSession getClientSession() {
        return this.session;
    }
}

