/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sshd.cli.CliSupport;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.keyprovider.MappedKeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.config.SshServerConfigFileReader;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.subsystem.SubsystemFactory;

public abstract class SshServerCliSupport
extends CliSupport {
    public static final String SHELL_FACTORY_OPTION = "ShellFactory";
    public static final ShellFactory DEFAULT_SHELL_FACTORY = InteractiveProcessShellFactory.INSTANCE;

    protected SshServerCliSupport() {
    }

    public static KeyPairProvider resolveServerKeys(PrintStream stderr, String hostKeyType, int hostKeySize, Collection<String> keyFiles) throws Exception {
        if (GenericUtils.isEmpty(keyFiles)) {
            List keys;
            KeyPair kp;
            PublicKey pubKey;
            String keyAlgorithm;
            AbstractGeneratorHostKeyProvider hostKeyProvider;
            Path hostKeyFile;
            if (SecurityUtils.isBouncyCastleRegistered()) {
                hostKeyFile = Paths.get("key.pem", new String[0]);
                hostKeyProvider = SecurityUtils.createGeneratorHostKeyProvider((Path)hostKeyFile);
            } else {
                hostKeyFile = Paths.get("key.ser", new String[0]);
                hostKeyProvider = new SimpleGeneratorHostKeyProvider(hostKeyFile);
            }
            hostKeyProvider.setAlgorithm(hostKeyType);
            if (hostKeySize != 0) {
                hostKeyProvider.setKeySize(hostKeySize);
            }
            if ("ECDSA".equalsIgnoreCase(keyAlgorithm = (pubKey = (kp = (KeyPair)(keys = (List)ValidateUtils.checkNotNullAndNotEmpty((Collection)hostKeyProvider.loadKeys(), (String)"Failed to load keys from %s", (Object[])new Object[]{hostKeyFile})).get(0)).getPublic()).getAlgorithm())) {
                keyAlgorithm = "EC";
            } else if ("ED25519".equals(keyAlgorithm)) {
                keyAlgorithm = "EdDSA";
            }
            if (!Objects.equals(keyAlgorithm, hostKeyType)) {
                Files.deleteIfExists(hostKeyFile);
                hostKeyProvider.clearLoadedKeys();
            }
            return hostKeyProvider;
        }
        ArrayList<KeyPair> pairs = new ArrayList<KeyPair>(keyFiles.size());
        for (String keyFilePath : keyFiles) {
            Path path = Paths.get(keyFilePath, new String[0]);
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    KeyPair kp = SecurityUtils.loadKeyPairIdentity((String)keyFilePath, (InputStream)inputStream, null);
                    pairs.add(kp);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception e) {
                stderr.append("Failed (").append(e.getClass().getSimpleName()).append(')').append(" to load host key file=").append(keyFilePath).append(": ").println(e.getMessage());
                stderr.flush();
                throw e;
            }
        }
        return new MappedKeyPairProvider(pairs);
    }

    public static ForwardingFilter setupServerForwarding(SshServer server, PropertyResolver options) {
        ForwardingFilter forwardFilter = SshServerConfigFileReader.resolveServerForwarding((PropertyResolver)options);
        server.setForwardingFilter(forwardFilter);
        return forwardFilter;
    }

    public static Object setupServerBanner(ServerFactoryManager server, PropertyResolver options) {
        Object banner = SshServerConfigFileReader.resolveBanner((PropertyResolver)options);
        PropertyResolverUtils.updateProperty((PropertyResolver)server, (String)"welcome-banner", (Object)banner);
        return banner;
    }

    public static List<NamedFactory<Command>> resolveServerSubsystems(PrintStream stderr, PropertyResolver options) throws Exception {
        String nameList;
        ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(SubsystemFactory.class);
        String classList = System.getProperty(SubsystemFactory.class.getName());
        if (GenericUtils.isNotEmpty((CharSequence)classList)) {
            String[] classes = GenericUtils.split((String)classList, (char)',');
            ArrayList<NamedFactory<Command>> subsystems = new ArrayList<NamedFactory<Command>>(classes.length);
            for (String fqcn : classes) {
                try {
                    Class<?> clazz = cl.loadClass(fqcn);
                    SubsystemFactory factory = (SubsystemFactory)SubsystemFactory.class.cast(clazz.newInstance());
                    subsystems.add((NamedFactory<Command>)factory);
                }
                catch (Exception e) {
                    stderr.append("Failed (").append(e.getClass().getSimpleName()).append(')').append(" to instantiate subsystem=").append(fqcn).append(": ").println(e.getMessage());
                    stderr.flush();
                    throw e;
                }
            }
            return subsystems;
        }
        String string = nameList = options == null ? null : options.getString("Subsystem");
        if ("none".equalsIgnoreCase(nameList)) {
            return Collections.emptyList();
        }
        boolean havePreferences = GenericUtils.isNotEmpty((CharSequence)nameList);
        Set preferredNames = !havePreferences ? Collections.emptySet() : (Collection)Stream.of(GenericUtils.split((String)nameList, (char)',')).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
        ServiceLoader<SubsystemFactory> loader = ServiceLoader.load(SubsystemFactory.class, cl);
        ArrayList<NamedFactory<Command>> subsystems = new ArrayList<NamedFactory<Command>>();
        for (SubsystemFactory factory : loader) {
            String name = factory.getName();
            if (havePreferences && !preferredNames.contains(name)) continue;
            subsystems.add((NamedFactory<Command>)factory);
        }
        return subsystems;
    }

    public static ShellFactory resolveShellFactory(PrintStream stderr, PropertyResolver options) throws Exception {
        String factory;
        String string = factory = options == null ? null : options.getString(SHELL_FACTORY_OPTION);
        if (GenericUtils.isEmpty((CharSequence)factory)) {
            return DEFAULT_SHELL_FACTORY;
        }
        if ("none".equalsIgnoreCase(factory)) {
            return null;
        }
        ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(ShellFactory.class);
        try {
            Class<?> clazz = cl.loadClass(factory);
            Object instance = clazz.newInstance();
            return (ShellFactory)ShellFactory.class.cast(instance);
        }
        catch (Exception e) {
            stderr.append("Failed (").append(e.getClass().getSimpleName()).append(')').append(" to instantiate shell factory=").append(factory).append(": ").println(e.getMessage());
            stderr.flush();
            throw e;
        }
    }
}

