/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.solr.JSONTestUtil;
import org.apache.solr.SolrJettyTestBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.util.RestTestHarness;
import org.apache.solr.util.TestHarness;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.AfterClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class RestTestBase
extends SolrJettyTestBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static RestTestHarness restTestHarness;

    @AfterClass
    public static void cleanUpHarness() throws IOException {
        RestTestHarness localHarness = restTestHarness;
        if (localHarness != null) {
            localHarness.close();
            restTestHarness = null;
        }
    }

    public static void createJettyAndHarness(String solrHome, String configFile, String schemaFile, String context, boolean stopAtShutdown, SortedMap<ServletHolder, String> extraServlets) throws Exception {
        RestTestBase.createAndStartJetty(solrHome, configFile, schemaFile, context, stopAtShutdown, extraServlets);
        restTestHarness = new RestTestHarness(() -> jetty.getBaseUrl().toString() + "/collection1");
    }

    public static void assertU(String update) {
        RestTestBase.assertU(null, update);
    }

    public static void assertU(String message, String update) {
        RestTestBase.checkUpdateU(message, update, true);
    }

    public static void assertFailedU(String update) {
        RestTestBase.assertFailedU(null, update);
    }

    public static void assertFailedU(String message, String update) {
        RestTestBase.checkUpdateU(message, update, false);
    }

    private static void checkUpdateU(String message, String update, boolean shouldSucceed) {
        try {
            Object m;
            Object object = m = null == message ? "" : message + " ";
            if (shouldSucceed) {
                String response = restTestHarness.validateUpdate(update);
                if (response != null) {
                    RestTestBase.fail((String)((String)m + "update was not successful: " + response));
                }
            } else {
                String response = restTestHarness.validateErrorUpdate(update);
                if (response != null) {
                    RestTestBase.fail((String)((String)m + "update succeeded, but should have failed: " + response));
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid XML", e);
        }
    }

    public static void assertQ(String request, String ... tests) {
        try {
            String response;
            String results;
            String path;
            String query;
            int queryStartPos = ((String)request).indexOf(63);
            if (-1 == queryStartPos) {
                query = "";
                path = request;
            } else {
                query = ((String)request).substring(queryStartPos + 1);
                path = ((String)request).substring(0, queryStartPos);
            }
            if (!query.matches(".*wt=schema\\.xml.*")) {
                query = RestTestBase.setParam(query, "wt", "xml");
            }
            if (null != (results = TestHarness.validateXPath(response = restTestHarness.query((String)(request = path + "?" + RestTestBase.setParam(query, "indent", "on"))), tests))) {
                log.error("REQUEST FAILED: xpath={}\n\txml response was: {}\n\trequest was:{}", new Object[]{results, response, request});
                RestTestBase.fail((String)results);
            }
        }
        catch (XPathExpressionException e1) {
            throw new RuntimeException("XPath is invalid", e1);
        }
        catch (Exception e2) {
            SolrException.log((Logger)log, (String)("REQUEST FAILED: " + (String)request), (Throwable)e2);
            throw new RuntimeException("Exception during query", e2);
        }
    }

    public static String JQ(String request) throws IOException {
        request = RestTestBase.setWtJsonAndIndent(request);
        try {
            return restTestHarness.query(request);
        }
        catch (IOException e) {
            log.error("REQUEST FAILED: {}", (Object)request);
            throw e;
        }
    }

    public static void assertJQ(String request, String ... tests) throws Exception {
        RestTestBase.assertJQ(request, 1.0E-5, tests);
    }

    public static void assertJQ(String request, double delta, String ... tests) throws IOException {
        String response;
        request = RestTestBase.setWtJsonAndIndent(request);
        try {
            response = restTestHarness.query(request);
        }
        catch (IOException e) {
            log.error("REQUEST FAILED: {}", (Object)request);
            throw e;
        }
        for (String test : tests) {
            if (null == test || 0 == test.length()) continue;
            RestTestBase.assertJsonMatches(request, response, RestTestBase.json(test), delta);
        }
    }

    public static void assertJPut(String request, String content, String ... tests) throws IOException {
        RestTestBase.assertJPut(request, content, 1.0E-5, tests);
    }

    public static void assertJPut(String request, String content, double delta, String ... tests) throws IOException {
        String response;
        request = RestTestBase.setWtJsonAndIndent(request);
        try {
            response = restTestHarness.put(request, content);
        }
        catch (IOException e) {
            log.error("REQUEST FAILED: {}", (Object)request);
            throw e;
        }
        for (String test : tests) {
            if (null == test || 0 == test.length()) continue;
            RestTestBase.assertJsonMatches(request, response, RestTestBase.json(test), delta);
        }
    }

    private static void assertJsonMatches(String request, String response, String testJSON, double delta) throws IOException {
        try {
            String err = JSONTestUtil.match(response, testJSON, delta);
            if (err != null) {
                log.error("query failed JSON validation. error: {}\n expected: {}\n response: {}\n request: {}\n", new Object[]{err, testJSON, response, request});
                RestTestBase.fail((String)err);
            }
        }
        catch (IOException e) {
            log.error("JSON query validation threw an exception.\n expected: {}\n response: {}\n request: {}", new Object[]{testJSON, response, request});
            throw e;
        }
    }

    public static void assertJPost(String request, String content, String ... tests) throws Exception {
        RestTestBase.assertJPost(request, content, 1.0E-5, tests);
    }

    public static void assertJPost(String request, String content, double delta, String ... tests) throws Exception {
        String response;
        request = RestTestBase.setWtJsonAndIndent(request);
        try {
            response = restTestHarness.post(request, content);
        }
        catch (IOException e) {
            log.error("REQUEST FAILED: {}", (Object)request);
            throw e;
        }
        for (String test : tests) {
            if (null == test || 0 == test.length()) continue;
            RestTestBase.assertJsonMatches(request, response, RestTestBase.json(test), delta);
        }
    }

    public static void assertJDelete(String request, String ... tests) throws Exception {
        RestTestBase.assertJDelete(request, 1.0E-5, tests);
    }

    public static void assertJDelete(String request, double delta, String ... tests) throws Exception {
        String response;
        request = RestTestBase.setWtJsonAndIndent(request);
        try {
            response = restTestHarness.delete(request);
        }
        catch (IOException e) {
            log.error("REQUEST FAILED: {}", (Object)request);
            throw e;
        }
        for (String test : tests) {
            if (null == test || 0 == test.length()) continue;
            RestTestBase.assertJsonMatches(request, response, RestTestBase.json(test), delta);
        }
    }

    private static String setWtJsonAndIndent(String request) {
        String path;
        String query;
        int queryStartPos = ((String)request).indexOf(63);
        if (-1 == queryStartPos) {
            query = "";
            path = request;
        } else {
            query = ((String)request).substring(queryStartPos + 1);
            path = ((String)request).substring(0, queryStartPos);
        }
        query = RestTestBase.setParam(query, "wt", "json");
        request = path + "?" + RestTestBase.setParam(query, "indent", "on");
        return request;
    }

    private static String setParam(String query, String paramToSet, String valueToSet) {
        if (null == valueToSet) {
            valueToSet = "";
        }
        StringBuilder builder = new StringBuilder();
        if (null == query || query.trim().isEmpty()) {
            builder.append(paramToSet);
            builder.append('=');
            StrUtils.partialURLEncodeVal((StringBuilder)builder, (String)valueToSet);
            return builder.toString();
        }
        MultiMapSolrParams requestParams = SolrRequestParsers.parseQueryString((String)query);
        String[] values = requestParams.getParams(paramToSet);
        if (null == values) {
            builder.append(query);
            builder.append('&');
            builder.append(paramToSet);
            builder.append('=');
            StrUtils.partialURLEncodeVal((StringBuilder)builder, (String)valueToSet);
            return builder.toString();
        }
        if (1 == values.length && valueToSet.equals(values[0])) {
            return query;
        }
        boolean isFirst = true;
        for (Map.Entry entry : requestParams.getMap().entrySet()) {
            String key = (String)entry.getKey();
            String[] valarr = (String[])entry.getValue();
            if (key.equals(paramToSet)) continue;
            for (String val : valarr) {
                builder.append(isFirst ? "" : Character.valueOf('&'));
                isFirst = false;
                builder.append(key);
                builder.append('=');
                StrUtils.partialURLEncodeVal((StringBuilder)builder, (String)(null == val ? "" : val));
            }
        }
        builder.append(isFirst ? "" : Character.valueOf('&'));
        builder.append(paramToSet);
        builder.append('=');
        StrUtils.partialURLEncodeVal((StringBuilder)builder, (String)valueToSet);
        return builder.toString();
    }
}

