/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.solr.analytics.util.Point;

public class PercentileCalculator {
    public static <T extends Comparable<T>> List<T> getPercentiles(List<T> list, double[] percents) {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        int[] percs = new int[percents.length];
        for (int i = 0; i < percs.length; ++i) {
            percs[i] = (int)Math.round(percents[i] * (double)size - 0.5);
        }
        int[] percentiles = Arrays.copyOf(percs, percs.length);
        Arrays.sort(percentiles);
        if (percentiles[0] < 0 || percentiles[percentiles.length - 1] > size - 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<T> results = new ArrayList<T>(percs.length);
        PercentileCalculator.distributeAndFind(list, percentiles, 0, percentiles.length - 1);
        for (int i = 0; i < percs.length; ++i) {
            results.add(list.get(percs[i]));
        }
        return results;
    }

    private static <T extends Comparable<T>> void distributeAndFind(List<T> list, int[] percentiles, int beginIdx, int endIdx) {
        if (endIdx < beginIdx) {
            return;
        }
        int middleIdxb = beginIdx;
        int middleIdxe = beginIdx;
        int begin = beginIdx == 0 ? -1 : percentiles[beginIdx - 1];
        int end = endIdx == percentiles.length - 1 ? list.size() : percentiles[endIdx + 1];
        double middle = (double)(begin + end) / 2.0;
        for (int i = beginIdx; i <= endIdx; ++i) {
            double value = Math.abs((double)percentiles[i] - middle) - Math.abs((double)percentiles[middleIdxb] - middle);
            if (percentiles[i] == percentiles[middleIdxb]) {
                middleIdxe = i;
                continue;
            }
            if (!(value < 0.0)) continue;
            middleIdxb = i;
            do {
                middleIdxe = i++;
            } while (i <= endIdx && percentiles[middleIdxb] == percentiles[i]);
            break;
        }
        int middlePlace = percentiles[middleIdxb];
        int beginPlace = begin + 1;
        int endPlace = end - 1;
        PercentileCalculator.select(list, middlePlace, beginPlace, endPlace);
        PercentileCalculator.distributeAndFind(list, percentiles, beginIdx, middleIdxb - 1);
        PercentileCalculator.distributeAndFind(list, percentiles, middleIdxe + 1, endIdx);
    }

    private static <T extends Comparable<T>> void select(List<T> list, int place, int begin, int end) {
        Object split = end - begin < 10 ? (Comparable)list.get((int)(Math.random() * (double)(end - begin + 1)) + begin) : PercentileCalculator.split(list, begin, end);
        Point result = PercentileCalculator.partition(list, begin, end, split);
        if (place <= result.low) {
            PercentileCalculator.select(list, place, begin, result.low);
        } else if (place >= result.high) {
            PercentileCalculator.select(list, place, result.high, end);
        }
    }

    private static <T extends Comparable<T>> T split(List<T> list, int begin, int end) {
        int num = end - begin + 1;
        int recursiveSize = (int)Math.sqrt(num);
        int step = num / recursiveSize;
        for (int i = 1; i < recursiveSize; ++i) {
            int swapFrom = i * step + begin;
            int swapTo = i + begin;
            Comparable temp = (Comparable)list.get(swapFrom);
            list.set(swapFrom, list.get(swapTo));
            list.set(swapTo, temp);
        }
        PercentileCalculator.select(list, --recursiveSize / 2 + begin, begin, recursiveSize + begin);
        return (T)((Comparable)list.get(recursiveSize / 2 + begin));
    }

    private static <T extends Comparable<T>> Point partition(List<T> list, int begin, int end, T indexElement) {
        Comparable temp;
        int right;
        int left = begin;
        for (right = end; left <= right; ++left, --right) {
            while (((Comparable)list.get(left)).compareTo(indexElement) < 0) {
                ++left;
            }
            while (right != begin - 1 && ((Comparable)list.get(right)).compareTo(indexElement) >= 0) {
                --right;
            }
            if (right <= left) {
                --left;
                ++right;
                break;
            }
            temp = (Comparable)list.get(left);
            list.set(left, list.get(right));
            list.set(right, temp);
        }
        while (left > begin - 1 && ((Comparable)list.get(left)).compareTo(indexElement) >= 0) {
            --left;
        }
        while (right < end + 1 && ((Comparable)list.get(right)).compareTo(indexElement) <= 0) {
            ++right;
        }
        for (int rightMove = right + 1; rightMove < end + 1; ++rightMove) {
            if (!((Comparable)list.get(rightMove)).equals(indexElement)) continue;
            temp = (Comparable)list.get(rightMove);
            list.set(rightMove, list.get(right));
            list.set(right, temp);
            while (((Comparable)list.get(++right)).equals(indexElement)) {
            }
            if (rightMove > right) continue;
            rightMove = right;
        }
        return new Point(left, right);
    }
}

