/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import java.text.ParseException;
import java.util.Date;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.analytics.util.valuesource.MultiDateFunction;
import org.apache.solr.util.DateMathParser;

public class DateMathFunction
extends MultiDateFunction {
    public static final String NAME = "date_math";
    private final DateMathParser parser = new DateMathParser();

    public DateMathFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return NAME;
    }

    @Override
    protected long func(int doc, FunctionValues[] valsArr) {
        long time = 0L;
        Date date = (Date)valsArr[0].objectVal(doc);
        try {
            this.parser.setNow(date);
            for (int count = 1; count < valsArr.length; ++count) {
                date = this.parser.parseMath(valsArr[count].strVal(doc));
                this.parser.setNow(date);
            }
            time = this.parser.getNow().getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            time = date.getTime();
        }
        return time;
    }
}

