/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.valuesource.ConstNumberSource;
import org.apache.lucene.queries.function.valuesource.ConstValueSource;

public class ConstDoubleSource
extends ConstNumberSource {
    public static final String NAME = "const_num";
    final double constant;

    public ConstDoubleSource(double constant) {
        this.constant = constant;
    }

    public String description() {
        return this.name() + "(" + this.getFloat() + ")";
    }

    protected String name() {
        return NAME;
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        return new DoubleDocValues((ValueSource)this){

            public double doubleVal(int doc) {
                return ConstDoubleSource.this.constant;
            }

            public boolean exists(int doc) {
                return true;
            }
        };
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.constant) * 31;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConstValueSource)) {
            return false;
        }
        ConstDoubleSource other = (ConstDoubleSource)((Object)o);
        return this.constant == other.constant;
    }

    public int getInt() {
        return (int)this.constant;
    }

    public long getLong() {
        return (long)this.constant;
    }

    public float getFloat() {
        return (float)this.constant;
    }

    public double getDouble() {
        return this.constant;
    }

    public Number getNumber() {
        return new Double(this.constant);
    }

    public boolean getBool() {
        return this.constant != 0.0;
    }
}

