/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.accumulator.facet;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.analytics.accumulator.ValueAccumulator;
import org.apache.solr.analytics.accumulator.facet.FacetValueAccumulator;
import org.apache.solr.analytics.util.AnalyticsParsers;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;

public class FieldFacetAccumulator
extends ValueAccumulator {
    protected final AnalyticsParsers.Parser parser;
    protected final FacetValueAccumulator parent;
    protected final String name;
    protected final SolrIndexSearcher searcher;
    protected final SchemaField schemaField;
    protected final boolean multiValued;
    protected final boolean numField;
    protected final boolean dateField;
    protected SortedSetDocValues setValues;
    protected SortedDocValues sortValues;
    protected NumericDocValues numValues;
    protected Bits numValuesBits;

    public FieldFacetAccumulator(SolrIndexSearcher searcher, FacetValueAccumulator parent, SchemaField schemaField) throws IOException {
        if (!schemaField.hasDocValues()) {
            throw new IOException("Field '" + schemaField.getName() + "' does not have docValues and therefore cannot be faceted over.");
        }
        this.searcher = searcher;
        this.schemaField = schemaField;
        this.name = schemaField.getName();
        this.multiValued = schemaField.multiValued();
        this.numField = schemaField.getType().getNumericType() != null;
        this.dateField = schemaField.getType() instanceof DateValueFieldType;
        this.parent = parent;
        this.parser = AnalyticsParsers.getParser(schemaField.getType().getClass());
    }

    public static FieldFacetAccumulator create(SolrIndexSearcher searcher, FacetValueAccumulator parent, SchemaField facetField) throws IOException {
        return new FieldFacetAccumulator(searcher, parent, facetField);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        if (this.multiValued) {
            this.setValues = context.reader().getSortedSetDocValues(this.name);
        } else if (this.numField) {
            this.numValues = context.reader().getNumericDocValues(this.name);
            this.numValuesBits = context.reader().getDocsWithField(this.name);
        } else {
            this.sortValues = context.reader().getSortedDocValues(this.name);
        }
    }

    public void collect(int doc) throws IOException {
        if (this.multiValued) {
            boolean exists = false;
            if (this.setValues != null) {
                int term;
                this.setValues.setDocument(doc);
                while ((long)(term = (int)this.setValues.nextOrd()) != -1L) {
                    exists = true;
                    BytesRef value = this.setValues.lookupOrd((long)term);
                    this.parent.collectField(doc, this.name, this.parser.parse(value));
                }
            }
            if (!exists) {
                this.parent.collectField(doc, this.name, "(MISSING)");
            }
        } else if (this.numField) {
            if (this.numValues != null) {
                long v = this.numValues.get(doc);
                if (v != 0L || this.numValuesBits.get(doc)) {
                    this.parent.collectField(doc, this.name, ((AnalyticsParsers.NumericParser)this.parser).parseNum(v));
                } else {
                    this.parent.collectField(doc, this.name, "(MISSING)");
                }
            } else {
                this.parent.collectField(doc, this.name, "(MISSING)");
            }
        } else if (this.sortValues != null) {
            int ord = this.sortValues.getOrd(doc);
            if (ord < 0) {
                this.parent.collectField(doc, this.name, "(MISSING)");
            } else {
                this.parent.collectField(doc, this.name, this.parser.parse(this.sortValues.lookupOrd(ord)));
            }
        } else {
            this.parent.collectField(doc, this.name, "(MISSING)");
        }
    }

    @Override
    public void compute() {
    }

    @Override
    public NamedList<?> export() {
        return null;
    }

    public boolean needsScores() {
        return true;
    }
}

