/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.resourcebuilder.api.ResourceBuilder;
import org.apache.sling.resourcebuilder.api.ResourceBuilderFactory;
import org.apache.sling.resourcebuilder.impl.ResourceBuilderFactoryService;
import org.apache.sling.scripting.core.impl.BindingsValuesProvidersByContextImpl;
import org.apache.sling.scripting.core.impl.ScriptEngineManagerFactory;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.builder.ContentBuilder;
import org.apache.sling.testing.mock.sling.context.ContextResourceResolverFactory;
import org.apache.sling.testing.mock.sling.context.ModelAdapterFactoryUtil;
import org.apache.sling.testing.mock.sling.context.UniqueRoot;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.apache.sling.testing.mock.sling.services.MockMimeTypeService;
import org.apache.sling.testing.mock.sling.services.MockSlingSettingService;
import org.apache.sling.testing.mock.sling.servlet.MockRequestPathInfo;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@ConsumerType
public class SlingContextImpl
extends OsgiContextImpl {
    static final Set<String> DEFAULT_RUN_MODES = ImmutableSet.builder().add((Object)"publish").build();
    private static final String RESOURCERESOLVERFACTORYACTIVATOR_PID = "org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl";
    protected ResourceResolverFactory resourceResolverFactory;
    protected ResourceResolverType resourceResolverType;
    protected ResourceResolver resourceResolver;
    protected MockSlingHttpServletRequest request;
    protected MockSlingHttpServletResponse response;
    protected SlingScriptHelper slingScriptHelper;
    protected ContentLoader contentLoader;
    protected ContentLoader contentLoaderAutoCommit;
    protected ContentBuilder contentBuilder;
    protected ResourceBuilder resourceBuilder;
    protected UniqueRoot uniqueRoot;
    private Map<String, Object> resourceResolverFactoryActivatorProps;

    protected void setResourceResolverType(ResourceResolverType resourceResolverType) {
        this.resourceResolverType = resourceResolverType;
    }

    protected void setResourceResolverFactoryActivatorProps(Map<String, Object> props) {
        this.resourceResolverFactoryActivatorProps = props;
    }

    protected void setUp() {
        super.setUp();
        MockSling.setAdapterManagerBundleContext(this.bundleContext());
        if (this.resourceResolverFactoryActivatorProps != null) {
            MockOsgi.setConfigForPid((BundleContext)this.bundleContext(), (String)RESOURCERESOLVERFACTORYACTIVATOR_PID, this.resourceResolverFactoryActivatorProps);
        }
        if (this.resourceResolverType != ResourceResolverType.NONE) {
            this.resourceResolverFactory();
        }
        this.registerDefaultServices();
    }

    protected ResourceResolverFactory newResourceResolverFactory() {
        return ContextResourceResolverFactory.get(this.resourceResolverType, this.bundleContext());
    }

    private ResourceResolverFactory resourceResolverFactory() {
        if (this.resourceResolverFactory == null) {
            this.resourceResolverFactory = this.newResourceResolverFactory();
        }
        return this.resourceResolverFactory;
    }

    protected void registerDefaultServices() {
        this.registerInjectActivateService(new ScriptEngineManagerFactory());
        this.registerInjectActivateService(new BindingsValuesProvidersByContextImpl());
        this.registerInjectActivateService(new ModelAdapterFactory());
        this.registerInjectActivateServiceByClassName("org.apache.sling.models.impl.FirstImplementationPicker", "org.apache.sling.models.impl.ResourceTypeBasedResourcePicker", "org.apache.sling.models.impl.injectors.BindingsInjector", "org.apache.sling.models.impl.injectors.ChildResourceInjector", "org.apache.sling.models.impl.injectors.OSGiServiceInjector", "org.apache.sling.models.impl.injectors.RequestAttributeInjector", "org.apache.sling.models.impl.injectors.ResourcePathInjector", "org.apache.sling.models.impl.injectors.SelfInjector", "org.apache.sling.models.impl.injectors.SlingObjectInjector", "org.apache.sling.models.impl.injectors.ValueMapInjector", "org.apache.sling.models.impl.via.BeanPropertyViaProvider", "org.apache.sling.models.impl.via.ChildResourceViaProvider", "org.apache.sling.models.impl.via.ForcedResourceTypeViaProvider", "org.apache.sling.models.impl.via.ResourceSuperTypeViaProvider");
        this.registerService(SlingSettingsService.class, new MockSlingSettingService(DEFAULT_RUN_MODES));
        this.registerService(MimeTypeService.class, (Object)new MockMimeTypeService());
        this.registerInjectActivateService(new ResourceBuilderFactoryService());
        ModelAdapterFactoryUtil.addModelsForManifestEntries(this.bundleContext());
    }

    private void registerInjectActivateServiceByClassName(String ... classNames) {
        for (String className : classNames) {
            try {
                Class<?> clazz = Class.forName(className);
                this.registerInjectActivateService(clazz.newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    protected void tearDown() {
        if (this.resourceResolver != null) {
            this.resourceResolver.revert();
            Session session = (Session)this.resourceResolver.adaptTo(Session.class);
            if (session != null) {
                try {
                    session.refresh(false);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
            if (this.uniqueRoot != null) {
                this.uniqueRoot.cleanUp();
            }
            this.resourceResolver.close();
        }
        MockSling.clearAdapterManagerBundleContext();
        this.resourceResolver = null;
        this.request = null;
        this.response = null;
        this.slingScriptHelper = null;
        this.contentLoader = null;
        this.contentLoaderAutoCommit = null;
        this.contentBuilder = null;
        this.resourceBuilder = null;
        this.uniqueRoot = null;
        this.resourceResolverFactory = null;
        super.tearDown();
    }

    public final ResourceResolverType resourceResolverType() {
        return this.resourceResolverType;
    }

    public final ResourceResolver resourceResolver() {
        if (this.resourceResolver == null) {
            try {
                this.resourceResolver = this.resourceResolverFactory().getAdministrativeResourceResolver(null);
            }
            catch (LoginException ex) {
                throw new RuntimeException("Creating resource resolver failed.", ex);
            }
        }
        return this.resourceResolver;
    }

    public final MockSlingHttpServletRequest request() {
        if (this.request == null) {
            this.request = new MockSlingHttpServletRequest(this.resourceResolver(), this.bundleContext());
            SlingBindings bindings = new SlingBindings();
            bindings.put((Object)"request", (Object)this.request);
            bindings.put((Object)"response", (Object)this.response());
            bindings.put((Object)"sling", (Object)this.slingScriptHelper());
            this.request.setAttribute(SlingBindings.class.getName(), bindings);
        }
        return this.request;
    }

    public final MockRequestPathInfo requestPathInfo() {
        return (MockRequestPathInfo)this.request().getRequestPathInfo();
    }

    public final MockSlingHttpServletResponse response() {
        if (this.response == null) {
            this.response = new MockSlingHttpServletResponse();
        }
        return this.response;
    }

    public final SlingScriptHelper slingScriptHelper() {
        if (this.slingScriptHelper == null) {
            this.slingScriptHelper = MockSling.newSlingScriptHelper((SlingHttpServletRequest)this.request(), (SlingHttpServletResponse)this.response(), this.bundleContext());
        }
        return this.slingScriptHelper;
    }

    public ContentLoader load() {
        return this.load(true);
    }

    public ContentLoader load(boolean autoCommit) {
        if (autoCommit) {
            if (this.contentLoaderAutoCommit == null) {
                this.contentLoaderAutoCommit = new ContentLoader(this.resourceResolver(), this.bundleContext(), true);
            }
            return this.contentLoaderAutoCommit;
        }
        if (this.contentLoader == null) {
            this.contentLoader = new ContentLoader(this.resourceResolver(), this.bundleContext(), false);
        }
        return this.contentLoader;
    }

    public ContentBuilder create() {
        if (this.contentBuilder == null) {
            this.contentBuilder = new ContentBuilder(this.resourceResolver());
        }
        return this.contentBuilder;
    }

    public ResourceBuilder build() {
        if (this.resourceBuilder == null) {
            this.resourceBuilder = ((ResourceBuilderFactory)this.getService(ResourceBuilderFactory.class)).forResolver(this.resourceResolver());
        }
        return this.resourceBuilder;
    }

    public final Resource currentResource() {
        return this.request().getResource();
    }

    public final Resource currentResource(String resourcePath) {
        if (resourcePath != null) {
            Resource resource = this.resourceResolver().getResource(resourcePath);
            if (resource == null) {
                throw new IllegalArgumentException("Resource does not exist: " + resourcePath);
            }
            return this.currentResource(resource);
        }
        return this.currentResource((Resource)null);
    }

    public final Resource currentResource(Resource resource) {
        this.request().setResource(resource);
        return resource;
    }

    public final void addModelsForPackage(String packageName) {
        ModelAdapterFactoryUtil.addModelsForPackages(this.bundleContext(), packageName);
    }

    public final void addModelsForPackage(String ... packageNames) {
        ModelAdapterFactoryUtil.addModelsForPackages(this.bundleContext(), packageNames);
    }

    public final void addModelsForClasses(String ... classNames) {
        ModelAdapterFactoryUtil.addModelsForClasses(this.bundleContext(), classNames);
    }

    public final void addModelsForClasses(Class ... classes) {
        ModelAdapterFactoryUtil.addModelsForClasses(this.bundleContext(), classes);
    }

    public final void runMode(String ... runModes) {
        ImmutableSet newRunModes = ImmutableSet.builder().add((Object[])runModes).build();
        ServiceReference ref = this.bundleContext().getServiceReference(SlingSettingsService.class);
        if (ref != null) {
            MockSlingSettingService slingSettings = (MockSlingSettingService)this.bundleContext().getService(ref);
            slingSettings.setRunModes((Set<String>)newRunModes);
        }
    }

    public UniqueRoot uniqueRoot() {
        if (this.uniqueRoot == null) {
            this.uniqueRoot = new UniqueRoot(this);
        }
        return this.uniqueRoot;
    }

    public final <T1, T2> void registerAdapter(Class<T1> adaptableClass, Class<T2> adapterClass, final T2 adapter) {
        this.registerAdapter(adaptableClass, adapterClass, new Function<T1, T2>(){

            public T2 apply(T1 input) {
                return adapter;
            }
        });
    }

    public final <T1, T2> void registerAdapter(Class<T1> adaptableClass, Class<T2> adapterClass, final Function<T1, T2> adaptHandler) {
        AdapterFactory adapterFactory = new AdapterFactory(){

            public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
                return (AdapterType)adaptHandler.apply(adaptable);
            }
        };
        this.registerService(AdapterFactory.class, adapterFactory, (Map)ImmutableMap.builder().put((Object)"adaptables", (Object)new String[]{adaptableClass.getName()}).put((Object)"adapters", (Object)new String[]{adapterClass.getName()}).put((Object)"service.ranking", (Object)Integer.MIN_VALUE).build());
    }
}

