/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.jcr.MockQuery;
import org.apache.sling.testing.mock.jcr.MockQueryManager;
import org.apache.sling.testing.mock.jcr.MockQueryResult;
import org.apache.sling.testing.mock.jcr.MockQueryResultHandler;
import org.apache.sling.testing.mock.jcr.MockRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public final class MockJcr {
    public static final String DEFAULT_WORKSPACE = "mockedWorkspace";
    public static final String DEFAULT_USER_ID = "admin";

    private MockJcr() {
    }

    @NotNull
    public static Repository newRepository() {
        return new MockRepository();
    }

    @NotNull
    public static Session newSession() {
        return MockJcr.newSession(null, null);
    }

    @NotNull
    public static Session newSession(@Nullable String userId, @Nullable String workspaceName) {
        try {
            return MockJcr.newRepository().login((Credentials)new SimpleCredentials(StringUtils.defaultString((String)userId, (String)DEFAULT_USER_ID), new char[0]), StringUtils.defaultString((String)workspaceName, (String)DEFAULT_WORKSPACE));
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Creating mocked JCR session failed.", ex);
        }
    }

    public static void setQueryResult(@NotNull Session session, @NotNull List<Node> resultList) {
        MockJcr.setQueryResult(MockJcr.getQueryManager(session), resultList);
    }

    public static void setQueryResult(@NotNull QueryManager queryManager, final @NotNull List<Node> resultList) {
        MockJcr.addQueryResultHandler(queryManager, new MockQueryResultHandler(){

            @Override
            public MockQueryResult executeQuery(MockQuery query) {
                return new MockQueryResult(resultList);
            }
        });
    }

    public static void setQueryResult(@NotNull Session session, @NotNull String statement, @NotNull String language, @NotNull List<Node> resultList) {
        MockJcr.setQueryResult(MockJcr.getQueryManager(session), statement, language, resultList);
    }

    public static void setQueryResult(@NotNull QueryManager queryManager, final @NotNull String statement, final @NotNull String language, final @NotNull List<Node> resultList) {
        MockJcr.addQueryResultHandler(queryManager, new MockQueryResultHandler(){

            @Override
            public MockQueryResult executeQuery(MockQuery query) {
                if (StringUtils.equals((CharSequence)query.getStatement(), (CharSequence)statement) && StringUtils.equals((CharSequence)query.getLanguage(), (CharSequence)language)) {
                    return new MockQueryResult(resultList);
                }
                return null;
            }
        });
    }

    public static void addQueryResultHandler(@NotNull Session session, @NotNull MockQueryResultHandler resultHandler) {
        MockJcr.addQueryResultHandler(MockJcr.getQueryManager(session), resultHandler);
    }

    public static void addQueryResultHandler(@NotNull QueryManager queryManager, @NotNull MockQueryResultHandler resultHandler) {
        ((MockQueryManager)queryManager).addResultHandler(resultHandler);
    }

    @NotNull
    private static QueryManager getQueryManager(@NotNull Session session) {
        try {
            return session.getWorkspace().getQueryManager();
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to access query manager.", ex);
        }
    }
}

