/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.sling.testing.clients.SlingHttpResponse;

public class ClientException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int httpStatusCode = -1;
    private HttpUriRequest request;
    private SlingHttpResponse response;

    @Deprecated
    public ClientException(String message) {
        this(message, null);
    }

    @Deprecated
    public ClientException(String message, Throwable throwable) {
        this(message, -1, throwable);
    }

    @Deprecated
    public ClientException(String message, int httpStatusCode) {
        this(message, httpStatusCode, null);
    }

    @Deprecated
    public ClientException(String message, int httpStatusCode, Throwable throwable) {
        super(message, throwable);
        this.httpStatusCode = httpStatusCode;
    }

    @Deprecated
    public ClientException(String message, Throwable throwable, HttpUriRequest request, SlingHttpResponse response) {
        this(message, throwable);
        this.request = request;
        this.response = response;
        if (this.response != null) {
            this.httpStatusCode = response.getStatusLine().getStatusCode();
        }
    }

    public HttpUriRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpUriRequest request) {
        this.request = request;
    }

    public SlingHttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(SlingHttpResponse response) {
        this.response = response;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.httpStatusCode > -1) {
            message = message + "(return code=" + this.httpStatusCode + ")";
        }
        return message;
    }

    @Override
    public String toString() {
        StringBuilder messageBuilder = new StringBuilder(super.toString()).append(System.lineSeparator());
        if (null != this.request) {
            messageBuilder.append("Request: ");
            messageBuilder.append(this.request.getMethod()).append(" ").append(this.request.getURI());
            messageBuilder.append(System.lineSeparator());
        }
        if (null != this.response) {
            messageBuilder.append("Response: ");
            messageBuilder.append(this.response.getStatusLine().getStatusCode()).append(" ").append(this.response.getStatusLine().getReasonPhrase());
            messageBuilder.append(this.response.getContent());
        }
        return messageBuilder.toString();
    }
}

