/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.python.core.JavaImporter;
import org.python.core.Options;
import org.python.core.PackageManager;
import org.python.core.PollingInputStream;
import org.python.core.PrecompiledImporter;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyEllipsis;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyNotImplemented;
import org.python.core.PyObject;
import org.python.core.PySingleton;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySyntaxError;
import org.python.core.PySystemStateFunctions;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PythonTraceFunction;
import org.python.core.StderrWrapper;
import org.python.core.StdoutWrapper;
import org.python.core.SysPackageManager;
import org.python.core.TraceFunction;
import org.python.core.ZipFileImporter;
import org.python.core.__builtin__;
import org.python.core.adapter.ClassicPyObjectAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.codecs;
import org.python.modules.Setup;

public class PySystemState
extends PyObject {
    public static final String JYTHON_JAR = "jython.jar";
    private static final String JAR_URL_PREFIX = "jar:file:";
    private static final String JAR_SEPARATOR = "!";
    private static final String PYTHON_CACHEDIR = "python.cachedir";
    protected static final String PYTHON_CACHEDIR_SKIP = "python.cachedir.skip";
    protected static final String CACHEDIR_DEFAULT_NAME = "cachedir";
    public static String version = "2.2rc3";
    private static int PY_MAJOR_VERSION = 2;
    private static int PY_MINOR_VERSION = 2;
    private static int PY_MICRO_VERSION = 0;
    private static int PY_RELEASE_LEVEL = 12;
    private static int PY_RELEASE_SERIAL = 3;
    public static int hexversion = PY_MAJOR_VERSION << 24 | PY_MINOR_VERSION << 16 | PY_MICRO_VERSION << 8 | PY_RELEASE_LEVEL << 4 | PY_RELEASE_SERIAL << 0;
    public static PyTuple version_info;
    public static int maxunicode;
    public static String copyright;
    public PyList argv = new PyList();
    public PyObject modules;
    public PyList path;
    public static PyObject builtins;
    public PyList meta_path;
    public PyList path_hooks;
    public PyObject path_importer_cache;
    public static String platform;
    public static String byteorder;
    public PyObject ps1 = new PyString(">>> ");
    public PyObject ps2 = new PyString("... ");
    public static int maxint;
    public static int minint;
    public PyObject executable = Py.None;
    public static PyList warnoptions;
    private ClassLoader classLoader = null;
    public PyObject stdout;
    public PyObject stderr;
    public PyObject stdin;
    public PyObject __stdout__;
    public PyObject __stderr__;
    public PyObject __stdin__;
    public PyObject __displayhook__;
    public PyObject __excepthook__;
    public PyObject last_value = Py.None;
    public PyObject last_type = Py.None;
    public PyObject last_traceback = Py.None;
    public PyObject __dict__;
    private int recursionlimit = 1000;
    private static PyList defaultPath;
    private static PyList defaultArgv;
    public static Properties registry;
    public static String prefix;
    public static String exec_prefix;
    private static boolean initialized;
    public static PackageManager packageManager;
    public static File cachedir;
    private static Hashtable builtinNames;
    public static String[] builtin_module_names;
    public TraceFunction tracefunc = null;
    public TraceFunction profilefunc = null;

    public static void exit(PyObject pyObject) {
        throw new PyException(Py.SystemExit, pyObject);
    }

    public static void exit() {
        PySystemState.exit(Py.None);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static PyTuple exc_info() {
        PyException pyException = Py.getThreadState().exception;
        if (pyException == null) {
            return new PyTuple(new PyObject[]{Py.None, Py.None, Py.None});
        }
        return new PyTuple(new PyObject[]{pyException.type, pyException.value, pyException.traceback});
    }

    public static PyFrame _getframe() {
        return PySystemState._getframe(-1);
    }

    public static PyFrame _getframe(int n) {
        PyFrame pyFrame = Py.getFrame();
        while (n > 0 && pyFrame != null) {
            pyFrame = pyFrame.f_back;
            --n;
        }
        if (pyFrame == null) {
            throw Py.ValueError("call stack is not deep enough");
        }
        return pyFrame;
    }

    public PyObject __findattr__(String string) {
        if (string == "exc_value") {
            PyException pyException = Py.getThreadState().exception;
            if (pyException == null) {
                return null;
            }
            return pyException.value;
        }
        if (string == "exc_type") {
            PyException pyException = Py.getThreadState().exception;
            if (pyException == null) {
                return null;
            }
            return pyException.type;
        }
        if (string == "exc_traceback") {
            PyException pyException = Py.getThreadState().exception;
            if (pyException == null) {
                return null;
            }
            return pyException.traceback;
        }
        if (string == "warnoptions") {
            if (warnoptions == null) {
                warnoptions = new PyList();
            }
            return warnoptions;
        }
        PyObject pyObject = super.__findattr__(string);
        if (pyObject != null) {
            return pyObject;
        }
        return this.__dict__.__finditem__(string);
    }

    public void __setattr__(String string, PyObject pyObject) {
        PyType pyType = this.getType();
        if (pyType == null) {
            return;
        }
        PyObject pyObject2 = pyType.lookup(string);
        if (pyObject2 != null) {
            pyObject2.jtryset(this, pyObject);
            return;
        }
        if (this.__dict__ == null) {
            this.__dict__ = new PyStringMap();
        }
        this.__dict__.__setitem__(string, pyObject);
    }

    public void __delattr__(String string) {
        if (this.__dict__ != null) {
            this.__dict__.__delitem__(string);
            return;
        }
        throw Py.AttributeError("del '" + string + "'");
    }

    public void __rawdir__(PyDictionary pyDictionary) {
        pyDictionary.update(this.__dict__);
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "module 'sys'";
    }

    public String toString() {
        return "sys module";
    }

    public int getrecursionlimit() {
        return this.recursionlimit;
    }

    public void setrecursionlimit(int n) {
        if (n <= 0) {
            throw Py.ValueError("Recursion limit must be positive");
        }
        this.recursionlimit = n;
    }

    public PySystemState() {
        PySystemState.initialize();
        this.modules = new PyStringMap();
        this.argv = (PyList)defaultArgv.repeat(1);
        this.path = (PyList)defaultPath.repeat(1);
        this.path.append(Py.newString("__classpath__"));
        this.meta_path = new PyList();
        this.meta_path.append(new PrecompiledImporter());
        this.path_hooks = new PyList();
        this.path_hooks.append(new JavaImporter());
        this.path_hooks.append(PyJavaClass.lookup(ZipFileImporter.class));
        this.path_importer_cache = new PyDictionary();
        this.__stdout__ = this.stdout = new PyFile(System.out, "<stdout>");
        this.__stderr__ = this.stderr = new PyFile(System.err, "<stderr>");
        this.__stdin__ = this.stdin = new PyFile(this.getSystemIn(), "<stdin>");
        this.__displayhook__ = new PySystemStateFunctions("displayhook", 10, 1, 1);
        this.__excepthook__ = new PySystemStateFunctions("excepthook", 30, 3, 3);
        if (builtins == null) {
            builtins = new PyStringMap();
            __builtin__.fillWithBuiltins(builtins);
        }
        PyModule pyModule = new PyModule("__builtin__", builtins);
        this.modules.__setitem__("__builtin__", (PyObject)pyModule);
        if (this.getType() != null) {
            this.__dict__ = new PyStringMap();
            this.__dict__.invoke("update", this.getType().getDict());
            this.__dict__.__setitem__("displayhook", this.__displayhook__);
            this.__dict__.__setitem__("excepthook", this.__excepthook__);
        }
    }

    private static String findRoot(Properties properties, Properties properties2, String string) {
        String string2;
        String string3 = null;
        try {
            String string4;
            if (properties2 != null) {
                string3 = properties2.getProperty("python.home");
            }
            if (string3 == null) {
                string3 = properties.getProperty("python.home");
            }
            if (string3 == null) {
                string3 = properties.getProperty("install.root");
            }
            if ((string2 = properties.getProperty("java.version")) == null) {
                string2 = "???";
            }
            if ((string4 = string2.toLowerCase()).startsWith("java")) {
                string2 = string2.substring(4, string2.length());
            }
            if (string4.startsWith("jdk") || string4.startsWith("jre")) {
                string2 = string2.substring(3, string2.length());
            }
            if (string2.equals("12")) {
                string2 = "1.2";
            }
            if (string2 != null) {
                platform = "java" + string2;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (string3 == null && (string2 = properties.getProperty("java.class.path")) != null) {
            int n = string2.toLowerCase().indexOf(JYTHON_JAR);
            if (n >= 0) {
                int n2 = string2.lastIndexOf(File.pathSeparator, n) + 1;
                string3 = string2.substring(n2, n);
            } else {
                string3 = string;
            }
        }
        return string3;
    }

    private static void initRegistry(Properties properties, Properties properties2, boolean bl, String string) {
        Object object;
        if (registry != null) {
            Py.writeError("systemState", "trying to reinitialize registry");
            return;
        }
        registry = properties;
        exec_prefix = PySystemState.findRoot(properties, properties2, string);
        prefix = exec_prefix;
        if (prefix != null) {
            if (prefix.length() == 0) {
                exec_prefix = ".";
                prefix = ".";
            }
            try {
                PySystemState.addRegistryFile(new File(prefix, "registry"));
                object = new File(registry.getProperty("user.home"), ".jython");
                PySystemState.addRegistryFile((File)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (properties2 != null) {
            object = properties2.keys();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                String string3 = (String)properties2.get(string2);
                registry.put(string2, string3);
            }
        }
        if (bl && !registry.containsKey(PYTHON_CACHEDIR_SKIP)) {
            registry.put(PYTHON_CACHEDIR_SKIP, "true");
        }
        Options.setFromRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRegistryFile(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                registry = new Properties(registry);
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        registry.load(fileInputStream);
                    }
                    finally {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println("couldn't open registry file: " + file.toString());
                }
            } else {
                System.err.println("warning: " + file.toString() + " is a directory, not a file");
            }
        }
    }

    public static Properties getBaseProperties() {
        try {
            return System.getProperties();
        }
        catch (AccessControlException accessControlException) {
            return new Properties();
        }
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        PySystemState.initialize(PySystemState.getBaseProperties(), null, new String[]{""});
    }

    public static synchronized void initialize(Properties properties, Properties properties2, String[] stringArray) {
        PySystemState.initialize(properties, properties2, stringArray, null);
    }

    public static synchronized void initialize(Properties properties, Properties properties2, String[] stringArray, ClassLoader classLoader) {
        PySystemState.initialize(properties, properties2, stringArray, classLoader, new ClassicPyObjectAdapter());
    }

    public static synchronized void initialize(Properties properties, Properties properties2, String[] stringArray, ClassLoader classLoader, ExtensiblePyObjectAdapter extensiblePyObjectAdapter) {
        if (initialized) {
            return;
        }
        initialized = true;
        Py.setAdapter(extensiblePyObjectAdapter);
        boolean bl = false;
        String string = PySystemState.getJarFileName();
        if (string != null) {
            bl = PySystemState.isStandalone(string);
        }
        PySystemState.initRegistry(properties, properties2, bl, string);
        PySystemState.initBuiltins(registry);
        PySystemState.initStaticFields();
        defaultPath = PySystemState.initPath(registry, bl, string);
        defaultArgv = PySystemState.initArgv(stringArray);
        PySystemState.initPackages(registry);
        Py.defaultSystemState = new PySystemState();
        Py.setSystemState(Py.defaultSystemState);
        if (classLoader != null) {
            Py.defaultSystemState.setClassLoader(classLoader);
        }
        Py.initClassExceptions(builtins);
        new PySyntaxError("", 1, 1, "", "");
    }

    private static void initStaticFields() {
        Py.None = new PyNone();
        Py.NotImplemented = new PyNotImplemented();
        Py.NoKeywords = new String[0];
        Py.EmptyObjects = new PyObject[0];
        Py.EmptyTuple = new PyTuple(Py.EmptyObjects);
        Py.NoConversion = new PySingleton("Error");
        Py.Ellipsis = new PyEllipsis();
        Py.Zero = new PyInteger(0);
        Py.One = new PyInteger(1);
        Py.EmptyString = new PyString("");
        Py.Newline = new PyString("\n");
        Py.Space = new PyString(" ");
        Py.stderr = new StderrWrapper();
        Py.stdout = new StdoutWrapper();
        String string = null;
        if (PY_RELEASE_LEVEL == 10) {
            string = "alpha";
        } else if (PY_RELEASE_LEVEL == 11) {
            string = "beta";
        } else if (PY_RELEASE_LEVEL == 12) {
            string = "candidate";
        } else if (PY_RELEASE_LEVEL == 15) {
            string = "final";
        } else if (PY_RELEASE_LEVEL == 170) {
            string = "snapshot";
        }
        version_info = new PyTuple(new PyObject[]{Py.newInteger(PY_MAJOR_VERSION), Py.newInteger(PY_MINOR_VERSION), Py.newInteger(PY_MICRO_VERSION), Py.newString(string), Py.newInteger(PY_RELEASE_SERIAL)});
    }

    private static void initCacheDirectory(Properties properties) {
        if (Py.frozen) {
            cachedir = null;
            return;
        }
        String string = properties.getProperty(PYTHON_CACHEDIR_SKIP, "false");
        if (string.equalsIgnoreCase("true")) {
            cachedir = null;
            return;
        }
        cachedir = new File(properties.getProperty(PYTHON_CACHEDIR, CACHEDIR_DEFAULT_NAME));
        if (!cachedir.isAbsolute()) {
            cachedir = new File(prefix, cachedir.getPath());
        }
    }

    private static void initPackages(Properties properties) {
        PySystemState.initCacheDirectory(properties);
        File file = cachedir != null ? new File(cachedir, "packages") : null;
        packageManager = new SysPackageManager(file, properties);
    }

    private static PyList initArgv(String[] stringArray) {
        PyList pyList = new PyList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                pyList.append(new PyString(stringArray[i]));
            }
        }
        return pyList;
    }

    private static void addBuiltin(String string) {
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1, string.length()).trim();
            if (string2.equals("null")) {
                string2 = null;
            }
        } else {
            string3 = string.trim();
            string2 = "org.python.modules." + string3;
        }
        if (string2 != null) {
            builtinNames.put(string3, string2);
        } else {
            builtinNames.remove(string3);
        }
    }

    private static void initBuiltins(Properties properties) {
        builtinNames = new Hashtable();
        for (int i = 0; i < Setup.builtinModules.length; ++i) {
            PySystemState.addBuiltin(Setup.builtinModules[i]);
        }
        String string = properties.getProperty("python.modules.builtin", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            PySystemState.addBuiltin(stringTokenizer.nextToken());
        }
        int n = builtinNames.size();
        builtin_module_names = new String[n];
        Enumeration enumeration = builtinNames.keys();
        for (int i = 0; i < n; ++i) {
            PySystemState.builtin_module_names[i] = (String)enumeration.nextElement();
        }
    }

    static String getBuiltin(String string) {
        return (String)builtinNames.get(string);
    }

    private static PyList initPath(Properties properties, boolean bl, String string) {
        PyList pyList = new PyList();
        if (!Py.frozen) {
            PySystemState.addPaths(pyList, properties.getProperty("python.prepath", ""));
            if (prefix != null) {
                String string2 = new File(prefix, "Lib").toString();
                pyList.append(new PyString(string2));
            }
            PySystemState.addPaths(pyList, properties.getProperty("python.path", ""));
        }
        if (bl) {
            PySystemState.addPaths(pyList, string + "/Lib");
        }
        return pyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isStandalone(String string) {
        boolean bl = false;
        if (string != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(string);
                JarEntry jarEntry = jarFile.getJarEntry("Lib/javaos.py");
                bl = jarEntry != null;
            }
            catch (IOException iOException) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    private static String getJarFileName() {
        String string;
        String string2;
        String string3 = null;
        Class clazz = PySystemState.class;
        URL uRL = clazz.getResource((string2 = (string = clazz.getName()).substring(string.lastIndexOf(".") + 1)) + ".class");
        if (uRL != null) {
            try {
                String string4 = URLDecoder.decode(uRL.toString());
                int n = string4.indexOf(JAR_SEPARATOR);
                if (string4.startsWith(JAR_URL_PREFIX) && n > 0) {
                    string3 = string4.substring(JAR_URL_PREFIX.length(), n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string3;
    }

    private static void addPaths(PyList pyList, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            pyList.append(new PyString(stringTokenizer.nextToken().trim()));
        }
    }

    public static PyJavaPackage add_package(String string) {
        return PySystemState.add_package(string, null);
    }

    public static PyJavaPackage add_package(String string, String string2) {
        return packageManager.makeJavaPackage(string, string2, null);
    }

    public static void add_classdir(String string) {
        packageManager.addDirectory(new File(string));
    }

    public static void add_extdir(String string) {
        packageManager.addJarDir(string, false);
    }

    public static void add_extdir(String string, boolean bl) {
        packageManager.addJarDir(string, bl);
    }

    public void settrace(PyObject pyObject) {
        this.tracefunc = pyObject == Py.None ? null : new PythonTraceFunction(pyObject);
    }

    public void setprofile(PyObject pyObject) {
        this.profilefunc = pyObject == Py.None ? null : new PythonTraceFunction(pyObject);
    }

    private InputStream getSystemIn() {
        if (Options.pollStandardIn) {
            return new PollingInputStream(System.in);
        }
        return System.in;
    }

    public String getdefaultencoding() {
        return codecs.getDefaultEncoding();
    }

    public void setdefaultencoding(String string) {
        codecs.setDefaultEncoding(string);
    }

    static void displayhook(PyObject pyObject) {
        if (pyObject == Py.None) {
            return;
        }
        PySystemState pySystemState = Py.getThreadState().systemState;
        builtins.__setitem__("_", Py.None);
        Py.stdout.println(pyObject.__repr__());
        builtins.__setitem__("_", pyObject);
    }

    static void excepthook(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        Py.displayException(pyObject, pyObject2, pyObject3, null);
    }

    public void callExitFunc() throws PyIgnoreMethodTag {
        PyObject pyObject = this.__findattr__("exitfunc");
        if (pyObject != null) {
            try {
                pyObject.__call__();
            }
            catch (PyException pyException) {
                if (!Py.matchException(pyException, Py.SystemExit)) {
                    Py.println(this.stderr, Py.newString("Error in sys.exitfunc:"));
                }
                Py.printException(pyException);
            }
        }
    }

    static {
        maxunicode = 65535;
        copyright = "Copyright (c) 2000-2007, Jython Developers\nAll rights reserved.\n\nCopyright (c) 2000 BeOpen.com.\nAll Rights Reserved.\n\nCopyright (c) 2000 The Apache Software Foundation.  All rights\nreserved.\n\nCopyright (c) 1995-2000 Corporation for National Research Initiatives.\nAll Rights Reserved.\n\nCopyright (c) 1991-1995 Stichting Mathematisch Centrum, Amsterdam.\nAll Rights Reserved.\n\n";
        platform = "java";
        byteorder = "big";
        maxint = Integer.MAX_VALUE;
        minint = Integer.MIN_VALUE;
        exec_prefix = "";
        initialized = false;
        builtin_module_names = null;
    }
}

